/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.render;

import java.nio.FloatBuffer;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import saf.v3d.render.TriangleIterator;

public class TriangleQSIterator
implements TriangleIterator {
    private FloatBuffer vertices;
    private Quad quad = new Quad();
    private int index = 0;
    private boolean left = true;

    public TriangleQSIterator(FloatBuffer vertices) {
        this.vertices = vertices;
        if (vertices.limit() > 5) {
            vertices.rewind();
            this.quad.p2.x = vertices.get();
            this.quad.p2.y = vertices.get();
            this.quad.p2.z = vertices.get();
            this.quad.p3.x = vertices.get();
            this.quad.p3.y = vertices.get();
            this.quad.p3.z = vertices.get();
            this.index = 6;
        }
    }

    @Override
    public boolean hasNext() {
        return this.index < this.vertices.limit();
    }

    @Override
    public void next(Point3f p1, Point3f p2, Point3f p3) {
        if (this.left) {
            this.quad.p0.set((Tuple3f)this.quad.p2);
            this.quad.p1.set((Tuple3f)this.quad.p3);
            this.vertices.position(this.index);
            this.quad.p2.x = this.vertices.get();
            this.quad.p2.y = this.vertices.get();
            this.quad.p2.z = this.vertices.get();
            this.quad.p3.x = this.vertices.get();
            this.quad.p3.y = this.vertices.get();
            this.quad.p3.z = this.vertices.get();
            this.left = false;
            this.quad.left(p1, p2, p3);
        } else {
            this.quad.right(p1, p2, p3);
            this.index += 6;
            this.left = true;
        }
    }

    static class Quad {
        Point3f p0 = new Point3f();
        Point3f p1 = new Point3f();
        Point3f p2 = new Point3f();
        Point3f p3 = new Point3f();

        void left(Point3f p1, Point3f p2, Point3f p3) {
            p1.set((Tuple3f)this.p0);
            p2.set((Tuple3f)this.p1);
            p3.set((Tuple3f)this.p2);
        }

        void right(Point3f p1, Point3f p2, Point3f p3) {
            p1.set((Tuple3f)this.p2);
            p2.set((Tuple3f)this.p3);
            p3.set((Tuple3f)this.p1);
        }
    }
}

