/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.render;

import java.nio.FloatBuffer;
import javax.media.opengl.GL2;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import saf.v3d.render.LineShape;
import saf.v3d.render.RenderState;
import saf.v3d.render.Renderer;
import saf.v3d.render.Shape;
import saf.v3d.util.Utils3D;

public class LineListRenderer
implements Renderer {
    private static final float DELTA = 5.0f;
    private FloatBuffer vertices;
    private int listIndex;
    private int[] moveTo;
    private boolean invalid = true;

    public LineListRenderer(FloatBuffer vertices, int[] moveTo) {
        this.vertices = vertices;
        this.moveTo = moveTo;
        this.vertices.rewind();
    }

    private void init(GL2 gl) {
        this.listIndex = gl.glGenLists(1);
        this.vertices.rewind();
        gl.glNewList(this.listIndex, 4864);
        int i = 0;
        while (i < this.moveTo.length) {
            int startIndex = this.moveTo[i];
            int endIndex = i + 1 == this.moveTo.length ? this.vertices.limit() : this.moveTo[i + 1];
            gl.glBegin(3);
            int j = startIndex;
            while (j < endIndex) {
                gl.glVertex3f(this.vertices.get(j), this.vertices.get(j + 1), this.vertices.get(j + 2));
                j += 3;
            }
            gl.glEnd();
            ++i;
        }
        gl.glEndList();
        this.invalid = false;
    }

    public boolean intersects(Point3f pt) {
        int i = 0;
        while (i < this.moveTo.length) {
            int startIndex = this.moveTo[i];
            int endIndex = i + 1 == this.moveTo.length ? this.vertices.limit() : this.moveTo[i + 1];
            Point3f start = new Point3f(this.vertices.get(startIndex), this.vertices.get(startIndex + 1), this.vertices.get(startIndex + 2));
            Point3f end = new Point3f();
            int j = startIndex + 3;
            while (j < endIndex) {
                end.set(this.vertices.get(j), this.vertices.get(j + 1), this.vertices.get(j + 2));
                float distSq = Utils3D.distanceSquared(pt, start, end);
                System.out.println("distance: " + distSq);
                if (distSq <= 5.0f) {
                    return true;
                }
                start.set((Tuple3f)end);
                j += 3;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void dispose(GL2 gl) {
        if (this.listIndex != 0) {
            gl.glDeleteLists(this.listIndex, 1);
            this.invalid = true;
        }
    }

    @Override
    public void render(GL2 gl, RenderState rState) {
        if (this.invalid) {
            this.init(gl);
        }
        gl.glLineWidth((float)rState.lineWidth);
        rState.appearance.applyAppearance(gl);
        gl.glCallList(this.listIndex);
    }

    @Override
    public void invalidate() {
        this.invalid = true;
    }

    public int getMode() {
        return 3;
    }

    @Override
    public FloatBuffer getVertices() {
        return this.vertices;
    }

    @Override
    public Shape createShape() {
        return new LineShape(this);
    }
}

