/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.render;

import java.nio.FloatBuffer;
import javax.media.opengl.GL2;
import saf.v3d.render.PolygonRenderer;
import saf.v3d.render.PolygonShape;
import saf.v3d.render.RenderData;
import saf.v3d.render.RenderState;
import saf.v3d.render.Shape;
import saf.v3d.render.TriangleIterator;

public class DisplayListRenderer
implements PolygonRenderer {
    private RenderData renderData;
    private int listIndex = 0;
    private boolean invalid = true;

    public DisplayListRenderer(RenderData data) {
        this.renderData = data;
    }

    public DisplayListRenderer(FloatBuffer vertices, int mode) {
        this.renderData = new RenderData(vertices);
        this.renderData.defineSlice(mode, 0);
    }

    @Override
    public void dispose(GL2 gl) {
        if (this.listIndex != 0) {
            gl.glDeleteLists(this.listIndex, 1);
        }
        this.invalid = true;
        this.listIndex = 0;
    }

    private void init(GL2 gl) {
        this.listIndex = gl.glGenLists(1);
        gl.glNewList(this.listIndex, 4864);
        this.renderData.renderImmediate(gl);
        gl.glEndList();
    }

    @Override
    public void render(GL2 gl, RenderState rState) {
        if (this.invalid) {
            this.dispose(gl);
            this.init(gl);
            this.invalid = false;
        }
        rState.border.drawBorder(gl, this.listIndex, rState);
        gl.glPolygonMode(1032, rState.PolyMode);
        rState.appearance.applyAppearance(gl);
        gl.glCallList(this.listIndex);
    }

    @Override
    public void invalidate() {
        this.invalid = true;
    }

    @Override
    public TriangleIterator triangleIterator() {
        return this.renderData.triangleIterator();
    }

    @Override
    public FloatBuffer getVertices() {
        return this.renderData.getVertices();
    }

    @Override
    public Shape createShape() {
        return new PolygonShape(this);
    }
}

