/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.event;

import java.awt.event.MouseEvent;
import javax.media.opengl.GLAutoDrawable;
import javax.vecmath.Vector3f;
import saf.v3d.event.InputHandler;

public class MouseZoom
extends InputHandler {
    private float lastY;
    private float zFactor;
    private Vector3f translation = new Vector3f();
    private GLAutoDrawable canvas;

    public MouseZoom(GLAutoDrawable canvas) {
        this.canvas = canvas;
        this.zFactor = 0.01f;
    }

    public Vector3f getTranslation() {
        return this.translation;
    }

    public void reset() {
        this.translation.set(0.0f, 0.0f, 0.0f);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (evt.getButton() == 1 && this.isEnabled) {
            this.lastY = evt.getY();
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.isAltDown() && this.isEnabled) {
            int y = evt.getY();
            float dy = (float)y - this.lastY;
            this.translation.z += -dy * this.zFactor;
            this.lastY = y;
            this.canvas.display();
        }
    }
}

