/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.event;

import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import saf.v3d.scene.Camera;

public class MouseWheelSZoom
implements MouseWheelListener {
    private float zFactor;
    private float scale;
    private Camera camera;
    private boolean isEnabled = true;

    public MouseWheelSZoom(Camera camera) {
        this.camera = camera;
        this.zFactor = 0.01f;
        this.scale = 1.0f;
    }

    public float getScale() {
        return this.scale;
    }

    public void reset() {
        this.scale = 1.0f;
    }

    public void reset(float scale) {
        this.scale = scale;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent evt) {
        int units;
        float newScale;
        if (this.isEnabled && (newScale = this.scale + (float)(units = evt.getUnitsToScroll()) * this.zFactor) >= 0.0f) {
            this.scale = newScale;
            this.camera.scale(this.scale);
            this.camera.update();
        }
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public String toString() {
        return String.format("Zoom: s: %f", Float.valueOf(this.scale));
    }
}

