/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.event;

import java.awt.event.MouseEvent;
import javax.vecmath.Vector3f;
import saf.v3d.event.InputHandler;
import saf.v3d.scene.Camera;

public class MouseTranslate
extends InputHandler {
    private float lastX;
    private float lastY;
    private float xFactor;
    private float yFactor;
    private Vector3f translation = new Vector3f();
    private int buttonMask;
    private Camera camera;

    public MouseTranslate(Camera camera) {
        this(camera, 4, 0.01f, 0.01f);
    }

    public MouseTranslate(Camera camera, int buttonMask, float xFactor, float yFactor) {
        this.camera = camera;
        this.xFactor = xFactor;
        this.yFactor = yFactor;
        this.buttonMask = buttonMask;
    }

    public void reset() {
        this.lastX = 0.0f;
        this.lastY = 0.0f;
        this.translation.set(0.0f, 0.0f, 0.0f);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if ((evt.getModifiers() & this.buttonMask) != 0 && this.isEnabled && !evt.isShiftDown()) {
            this.lastX = evt.getX();
            this.lastY = evt.getY();
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if ((evt.getModifiers() & this.buttonMask) != 0 && this.isEnabled && !evt.isShiftDown()) {
            int x = evt.getX();
            int y = evt.getY();
            float dx = (float)x - this.lastX;
            float dy = (float)y - this.lastY;
            this.translation.x += dx * this.xFactor;
            this.translation.y += -dy * this.yFactor;
            this.lastX = x;
            this.lastY = y;
            this.camera.pan(this.translation);
            this.camera.update();
        }
    }

    public String toString() {
        return String.format("Translate: tx: %f, ty: %f, tz: %f", Float.valueOf(this.translation.x), Float.valueOf(this.translation.y), Float.valueOf(0.0f));
    }
}

