/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.event;

import java.awt.event.MouseEvent;
import saf.v3d.event.InputHandler;
import saf.v3d.scene.Camera;

public class MouseKeyZoom
extends InputHandler {
    private float zFactor;
    private float scale;
    private Camera camera;
    private boolean isEnabled = true;
    private int lastY = -1;
    private int buttonMask;

    public MouseKeyZoom(Camera camera, int buttonMask) {
        this.camera = camera;
        this.zFactor = 0.005f;
        this.scale = 1.0f;
        this.buttonMask = buttonMask;
    }

    public float getScale() {
        return this.scale;
    }

    public void reset() {
        this.scale = 1.0f;
    }

    public void reset(float scale) {
        this.scale = scale;
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if ((evt.getModifiers() & this.buttonMask) != 0 && this.isEnabled && evt.isShiftDown()) {
            int y = evt.getY();
            if (this.lastY != -1) {
                float dy = y - this.lastY;
                float newScale = this.scale + dy * this.zFactor;
                if (newScale >= 0.0f) {
                    this.scale = newScale;
                    this.lastY = y;
                    this.camera.scale(this.scale);
                    this.camera.update();
                }
            } else {
                this.lastY = y;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.lastY = -1;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    public String toString() {
        return String.format("Zoom: s: %f", Float.valueOf(this.scale));
    }
}

