/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d;

import javax.media.opengl.GL2;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import saf.v3d.picking.BoundingSphere;
import saf.v3d.render.RenderState;
import saf.v3d.render.Shape;

public class GridShape2D
implements Shape {
    private float cellSize;
    private int cols;
    private int rows;
    private BoundingSphere sphere;
    private int listIndex;
    private boolean invalid = true;

    public GridShape2D(float cellSize, int cols, int rows) {
        this.cellSize = cellSize;
        this.cols = cols;
        this.rows = rows;
        float width = (float)cols * cellSize;
        float height = (float)rows * cellSize;
        float radius = Math.max(width / 2.0f, height / 2.0f);
        this.sphere = new BoundingSphere(new Point3f(width / 2.0f, height / 2.0f, 0.0f), radius);
    }

    private void initDL(GL2 gl) {
        this.listIndex = gl.glGenLists(1);
        gl.glNewList(this.listIndex, 4864);
        gl.glBegin(1);
        float yLimit = this.cellSize * (float)this.rows;
        float xLimit = this.cellSize * (float)this.cols;
        float x = 0.0f;
        while (x <= xLimit) {
            gl.glVertex3f(x, 0.0f, 0.0f);
            gl.glVertex3f(x, yLimit, 0.0f);
            x += this.cellSize;
        }
        float y = 0.0f;
        while (y <= yLimit) {
            gl.glVertex3f(0.0f, y, 0.0f);
            gl.glVertex3f(xLimit, y, 0.0f);
            y += this.cellSize;
        }
        gl.glEnd();
        gl.glEndList();
        this.invalid = false;
    }

    @Override
    public BoundingSphere getLocalBounds() {
        return this.sphere;
    }

    @Override
    public boolean intersects(Point3f rayOrigin, Vector3f rayDirection) {
        return false;
    }

    @Override
    public boolean intersects(Point3f point) {
        return false;
    }

    @Override
    public void render(GL2 gl, RenderState state) {
        if (this.invalid) {
            this.initDL(gl);
        }
        state.appearance.applyAppearance(gl);
        gl.glLineWidth(1.0f);
        state.lineWidth = 1;
        gl.glCallList(this.listIndex);
    }

    @Override
    public void invalidate() {
        this.invalid = true;
    }
}

