/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d;

import com.jogamp.common.os.Platform;
import com.jogamp.opengl.util.awt.AWTGLReadBufferUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.media.opengl.awt.GLJPanel;
import javax.swing.JPanel;
import javax.vecmath.Color4f;
import javax.vecmath.Point3f;
import saf.v3d.Canvas;
import saf.v3d.CanvasListener;
import saf.v3d.ShapeFactory2D;
import saf.v3d.event.MouseKeyZoom;
import saf.v3d.event.MouseTranslate;
import saf.v3d.event.MouseWheelSZoom;
import saf.v3d.picking.BoundingSphere;
import saf.v3d.picking.PickListener;
import saf.v3d.picking.PickSupport2D;
import saf.v3d.render.RenderState;
import saf.v3d.scene.Camera;
import saf.v3d.scene.VRoot;
import saf.v3d.scene.VSpatial;

public class Canvas2D
implements GLEventListener,
Canvas {
    private GLAutoDrawable drawable;
    private JPanel panel;
    private Color4f background = new Color4f(Color.WHITE);
    private MouseTranslate translator;
    private MouseWheelSZoom wheelZoomer;
    private MouseKeyZoom keyZoomer;
    private PickSupport2D picker;
    private List<CanvasListener> listeners = new ArrayList<CanvasListener>();
    private VRoot root;
    private boolean initialized = false;
    private Camera camera;
    private RenderState rState = new RenderState();
    private Lock lock = new ReentrantLock();
    private ShapeFactory2D shapeFactory = new ShapeFactory2D();
    private int width;
    private int height;
    private float extentWidth;
    private float extentHeight;

    public Canvas2D() {
        GLProfile gp = GLProfile.get((String)"GL2");
        GLCapabilities caps = new GLCapabilities(gp);
        caps.setSampleBuffers(true);
        caps.setNumSamples(4);
        if (Platform.getOSType().equals((Object)Platform.OSType.MACOS) || Platform.getOSType().equals((Object)Platform.OSType.LINUX)) {
            this.drawable = new GLJPanel((GLCapabilitiesImmutable)caps);
            ((GLJPanel)this.drawable).setSurfaceScale(new int[]{1, 1});
        } else {
            this.drawable = new GLCanvas((GLCapabilitiesImmutable)caps);
        }
        this.drawable.addGLEventListener((GLEventListener)this);
        this.drawable.setAutoSwapBufferMode(false);
        this.camera = new Camera(this, this.drawable);
        this.addCanvasListener(this.camera);
        this.addCanvasListener(this.shapeFactory);
        this.root = this.camera.getRoot();
        this.root.id = "ROOT";
        this.translator = new MouseTranslate(this.camera, 4, 1.0f, 1.0f);
        this.wheelZoomer = new MouseWheelSZoom(this.camera);
        this.keyZoomer = new MouseKeyZoom(this.camera, 4);
        this.picker = new PickSupport2D(this);
    }

    public void setDefaultExtent(float width, float height) {
        this.extentWidth = width;
        this.extentHeight = height;
    }

    public BufferedImage createImage() {
        try {
            if (!this.drawable.getContext().isCurrent()) {
                this.drawable.getContext().makeCurrent();
            }
            AWTGLReadBufferUtil util = new AWTGLReadBufferUtil(this.drawable.getGLProfile(), true);
            return util.readPixelsToBufferedImage(this.drawable.getContext().getGL(), true);
        }
        catch (GLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public ShapeFactory2D getShapeFactory() {
        return this.shapeFactory;
    }

    @Override
    public void update() {
        this.drawable.display();
    }

    public Lock getRenderLock() {
        return this.lock;
    }

    public void vSpatialMoved(VSpatial spatial, Point3f localTrans) {
        for (CanvasListener listener : this.listeners) {
            listener.vSpatialMoved(spatial, localTrans);
        }
    }

    public void addCanvasListener(CanvasListener listener) {
        this.listeners.add(listener);
    }

    public void addPickListener(PickListener listener) {
        this.picker.addPickListener(listener);
    }

    public JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel(new BorderLayout(), false);
            this.panel.add((Component)this.drawable, "Center");
            this.panel.setMinimumSize(new Dimension(10, 10));
        }
        return this.panel;
    }

    public void init(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.setSwapInterval(0);
        gl.glClearColor(this.background.x, this.background.y, this.background.z, this.background.w);
        gl.glShadeModel(7425);
        gl.glTexEnvf(8960, 8704, 7681.0f);
        this.shapeFactory.invalidateRenderers(gl);
        this.root.invalidate(gl);
        for (CanvasListener listener : this.listeners) {
            listener.init(drawable, this.root);
        }
        if (!this.initialized) {
            Component canvas = (Component)drawable;
            canvas.addMouseListener(this.translator);
            canvas.addMouseMotionListener(this.translator);
            canvas.addMouseWheelListener(this.wheelZoomer);
            canvas.addMouseMotionListener(this.keyZoomer);
            canvas.addMouseListener(this.keyZoomer);
            canvas.addMouseListener(this.picker);
        }
        this.initialized = true;
    }

    public void dispose() {
        for (CanvasListener listener : this.listeners) {
            if (this.drawable.getContext() != null && !this.drawable.getContext().isCurrent()) {
                this.drawable.getContext().makeCurrent();
            }
            listener.dispose(this.drawable);
        }
        this.shapeFactory.dispose();
    }

    public void dispose(GLAutoDrawable drawable) {
        for (CanvasListener listener : this.listeners) {
            listener.dispose(drawable);
        }
    }

    public void display(GLAutoDrawable drawable) {
        try {
            this.lock.lock();
            this.rState.reset();
            this.rState.width = drawable.getSurfaceWidth();
            this.rState.height = drawable.getSurfaceHeight();
            GL2 gl = drawable.getGL().getGL2();
            gl.glClear(16384);
            this.camera.updateProjection(gl);
            gl.glMatrixMode(5888);
            gl.glPushMatrix();
            gl.glLoadIdentity();
            gl.glTranslatef(0.375f, 0.375f, 0.0f);
            gl.glPushMatrix();
            this.camera.applyViewTransforms(gl);
            this.root.draw(gl, this.rState);
            gl.glPopMatrix();
            gl.glPopMatrix();
            this.picker.process(gl, this.root);
            drawable.swapBuffers();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void resetCamera() {
        this.camera.reset();
    }

    private float calculateScaleFromSphere() {
        BoundingSphere sphere = this.root.getBoundingSphere();
        float diameter = sphere.getRadius() * 2.0f;
        float min = Math.min(this.width, this.height);
        float scale = 1.0f;
        if (diameter > min) {
            scale = diameter / min;
        }
        return scale;
    }

    private float calculateScaleFromExtents() {
        float scale = 1.0f;
        if (this.extentWidth > (float)this.width || this.extentHeight > (float)this.height) {
            if (this.extentWidth > (float)this.width) {
                scale = this.extentWidth / (float)this.width;
            }
            if (this.extentHeight > (float)this.height) {
                scale = Math.max(scale, this.extentHeight / (float)this.height);
            }
            scale += 0.1f;
        }
        return scale;
    }

    public void centerScene() {
        this.translator.reset();
        this.wheelZoomer.reset();
        this.keyZoomer.reset();
        this.camera.resetAndCenter();
        float scale = 1.0f;
        scale = this.extentWidth > 0.0f && this.extentHeight > 0.0f ? this.calculateScaleFromExtents() : this.calculateScaleFromSphere();
        this.wheelZoomer.reset(scale);
        this.keyZoomer.reset(scale);
        this.camera.scale(scale);
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho((double)((float)(-width) / 2.0f), (double)((float)width / 2.0f), (double)((float)(-height) / 2.0f), (double)((float)height / 2.0f), -1.0, 1.0);
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glDisable(2929);
        gl.glDisable(2896);
        gl.glEnable(3042);
        gl.glBlendFunc(770, 771);
        for (CanvasListener display : this.listeners) {
            display.reshape(drawable, width, height, this.root);
        }
        boolean firstReshape = this.width == 0;
        this.width = width;
        this.height = height;
        if (firstReshape) {
            this.centerScene();
        }
    }

    public void setBackgroundColor(Color color) {
        this.background.set(color);
    }

    public Color getBackgroundColor() {
        return this.background.get();
    }

    public VRoot getRoot() {
        return this.root;
    }
}

