/*
 * Decompiled with CFR 0.152.
 */
package simphony.util.messages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import simphony.util.messages.Log4jMessageListener;
import simphony.util.messages.MessageEvent;
import simphony.util.messages.MessageEventListener;

public class MessageCenter {
    private static final MessageCenter msgCenter = MessageCenter.getMessageCenter(MessageCenter.class);
    private static ArrayList<MessageEventListener> listeners = new ArrayList();
    private Log4jMessageListener logListener;

    public static MessageCenter getMessageCenter(Class clazz) {
        if (clazz == null) {
            RuntimeException ex = new RuntimeException("When creating a message center clazz must not be null");
            msgCenter.warn((Object)"MessageCenter.getMessageCenter: Warning, addLogger == true but clazz == null.  Cannot add a logger when the class parameter is null.", ex, new Object[0]);
        }
        return MessageCenter.getMessageCenter(clazz.getName(), true);
    }

    public static MessageCenter getMessageCenter(String name) {
        return MessageCenter.getMessageCenter(name, true);
    }

    public static MessageCenter getMessageCenter(String name, boolean addLogger) {
        MessageCenter newMsgCenter = new MessageCenter();
        if (addLogger) {
            if (name != null) {
                newMsgCenter.logListener = new Log4jMessageListener(name);
            } else {
                RuntimeException ex = new RuntimeException("When adding a logger name must not be null");
                msgCenter.warn((Object)"MessageCenter.getMessageCenter: Warning, addLogger == true but name == null.  Cannot add a logger when the name parameter is null.", ex, new Object[0]);
            }
        }
        return newMsgCenter;
    }

    public static MessageCenter getMessageCenter(Class clazz, Map properties) {
        return MessageCenter.getMessageCenter(clazz);
    }

    private MessageCenter() {
    }

    public void info(Object info, Object ... metaData) {
        this.fireMessageEvent(Level.INFO, info, null, metaData);
    }

    public void trace(Object info, Object ... metaData) {
        this.fireMessageEvent(Level.TRACE, info, null, metaData);
    }

    public void debug(Object info, Object ... metaData) {
        this.fireMessageEvent(Level.DEBUG, info, null, metaData);
    }

    public void warn(Object info, Object ... metaData) {
        this.fireMessageEvent(Level.WARN, info, null, metaData);
    }

    public void warn(Object info, Throwable error, Object ... metaData) {
        this.fireMessageEvent(Level.WARN, info, error, metaData);
    }

    public void error(Object info, Throwable error, Object ... metaData) {
        this.fireMessageEvent(Level.ERROR, info, error, metaData);
    }

    public void fatal(Object info, Throwable error, Object ... metaData) {
        this.fireMessageEvent(Level.FATAL, info, error, metaData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireMessageEvent(Level level, Object info, Throwable throwable, Object ... metaData) {
        List list;
        ArrayList<MessageEventListener> arrayList = listeners;
        synchronized (arrayList) {
            list = (List)listeners.clone();
        }
        MessageEvent event = new MessageEvent(this, level, info, throwable, metaData);
        for (MessageEventListener listener : list) {
            listener.messageReceived(event);
        }
        if (this.logListener != null) {
            this.logListener.messageReceived(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMessageListener(MessageEventListener listener) {
        ArrayList<MessageEventListener> arrayList = listeners;
        synchronized (arrayList) {
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMessageListener(MessageEventListener listener) {
        ArrayList<MessageEventListener> arrayList = listeners;
        synchronized (arrayList) {
            listeners.remove(listener);
        }
    }

    public static Collection<MessageEventListener> getMessageListeners() {
        return Collections.unmodifiableCollection(listeners);
    }

    public Log4jMessageListener getLogListener() {
        return this.logListener;
    }

    public void setLogListener(Log4jMessageListener logListener) {
        this.logListener = logListener;
    }
}

