/*
 * Decompiled with CFR 0.152.
 */
package saf.core.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;
import saf.core.runtime.PluginAttributes;

public class PluginReader
extends DefaultHandler2 {
    private static final String ATTRIBUTE_TAG = "attribute";
    private static final String PLUGIN_TAG = "plugin";
    private static final String ID_ATTRIBUTE = "id";
    private static final String VALUE_ATTRIBUTE = "value";
    private URL url;
    List<PluginAttributes> attributes = new ArrayList<PluginAttributes>();
    private PluginAttributes current = null;

    public PluginReader(URL url) {
        this.url = url;
    }

    public PluginAttributes parse() throws ParserConfigurationException, SAXException, IOException {
        this.attributes.clear();
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        InputStream inputStream = this.url.openStream();
        parser.parse(inputStream, (DefaultHandler)this);
        inputStream.close();
        return this.current;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(ATTRIBUTE_TAG)) {
            this.current.addAttribute(attributes.getValue(ID_ATTRIBUTE), attributes.getValue(VALUE_ATTRIBUTE));
        } else if (qName.equals(PLUGIN_TAG)) {
            this.current = new PluginAttributes(attributes.getValue(ID_ATTRIBUTE));
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return new InputSource(new StringReader(""));
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        return new InputSource(new StringReader(""));
    }
}

