/*
 * Decompiled with CFR 0.152.
 */
package saf.core.runtime;

import java.lang.reflect.InvocationTargetException;
import org.java.plugin.Plugin;
import org.java.plugin.PluginLifecycleException;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import saf.core.runtime.IApplicationRunnable;
import saf.core.runtime.PluginDefinitionException;
import simphony.util.messages.MessageCenter;

public class CorePlugin
extends Plugin {
    private static final String APP_RUN_ID = "IApplicationRunnable";
    private IApplicationRunnable appRunner;

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    public void run(String[] args) {
        try {
            this.loadAppPlugin();
            this.loadUIPlugin();
            this.runApplicationRunnable(args);
        }
        catch (Exception ex) {
            MessageCenter.getMessageCenter(((Object)((Object)this)).getClass()).error("Error instantiating plugins", ex, new Object[0]);
        }
    }

    private void loadUIPlugin() throws PluginLifecycleException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Plugin plugin = this.getManager().getPlugin("saf.core.ui");
        plugin.getClass().getMethod("initialize", new Class[0]).invoke((Object)plugin, new Object[0]);
    }

    private void loadAppPlugin() throws PluginLifecycleException, ClassNotFoundException, IllegalAccessException, InstantiationException, PluginDefinitionException {
        Class<?> appRunnerClass;
        ExtensionPoint extPoint = this.getManager().getRegistry().getExtensionPoint(this.getDescriptor().getId(), APP_RUN_ID);
        if (extPoint.getConnectedExtensions().size() != 1) {
            throw new PluginDefinitionException("Plugin must implement one and only one IApplicationRunnable");
        }
        Extension ext = (Extension)extPoint.getConnectedExtensions().iterator().next();
        Plugin plugin = this.getManager().getPlugin(ext.getDeclaringPluginDescriptor().getId());
        Class<?> pluginCls = plugin.getClass();
        this.appRunner = pluginCls.equals(appRunnerClass = pluginCls.getClassLoader().loadClass(ext.getParameter("class").valueAsString())) ? (IApplicationRunnable)plugin : (IApplicationRunnable)appRunnerClass.newInstance();
    }

    private void runApplicationRunnable(String[] args) {
        this.appRunner.run(args);
    }
}

