/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualizationOGL2D;

import repast.simphony.ui.probe.ValueLayerProbeObject2D;
import repast.simphony.valueLayer.ValueLayer;
import repast.simphony.visualizationOGL2D.ColorMapStyleAdapter;
import repast.simphony.visualizationOGL2D.ValueLayerStyleOGL;
import saf.v3d.grid.GridColorMap;
import saf.v3d.grid.GridMesh;
import saf.v3d.grid.VGridShape;
import saf.v3d.scene.VLayer;
import saf.v3d.scene.VSpatial;
import simphony.util.messages.MessageCenter;

public class ValueLayerDisplayLayer {
    private static MessageCenter msg = MessageCenter.getMessageCenter(ValueLayerDisplayLayer.class);
    public static final String VALUE_LAYER_KEY = "ValueLayerDisplayLayer.ValueLayerKey";
    private ValueLayer valueLayer;
    private ValueLayerStyleOGL style;
    private VLayer layer;
    private int xDim;
    private int yDim;
    private int[] origin;
    private VGridShape shape;

    public ValueLayerDisplayLayer(ValueLayer valueLayer, ValueLayerStyleOGL style, VLayer layer) {
        this.layer = layer;
        this.resetLayer(valueLayer, style);
    }

    public void resetLayer(ValueLayer valueLayer, ValueLayerStyleOGL style) {
        if (this.shape != null) {
            this.layer.removeAllChildren();
        }
        this.valueLayer = valueLayer;
        this.style = style;
        this.style.init(this.valueLayer);
        int[] dims = valueLayer.getDimensions().toIntArray(null);
        this.origin = valueLayer.getDimensions().originToIntArray(null);
        if (dims.length > 3 || dims.length == 3 && dims[2] != 0) {
            msg.error((Object)"Error while creating display for value error", (Throwable)new IllegalArgumentException("Value Layers with more than 2 dimensions are unsupported"), new Object[0]);
            return;
        }
        this.xDim = dims[0];
        this.yDim = dims[1];
        GridMesh grid = new GridMesh(this.yDim, this.xDim, style.getCellSize(), (GridColorMap)new ColorMapStyleAdapter(style, this.origin));
        this.shape = new VGridShape(grid, (Object)"DisplayLayerOGL2D.MODEL_OBJECT_KEY");
        this.shape.putProperty((Object)VALUE_LAYER_KEY, (Object)this);
        this.layer.addChild((VSpatial)this.shape);
    }

    public void update() {
        this.shape.update();
    }

    Object getProbedObject() {
        int[] location = (int[])this.shape.getProperty((Object)"DisplayLayerOGL2D.MODEL_OBJECT_KEY");
        if (location.length == 1) {
            location[0] = location[0] - this.origin[0];
        } else {
            location[0] = location[0] - this.origin[0];
            location[1] = location[1] - this.origin[1];
        }
        double[] loc = new double[location.length];
        int i = 0;
        while (i < location.length) {
            loc[i] = location[i];
            ++i;
        }
        return new ValueLayerProbeObject2D(loc, this.valueLayer);
    }
}

