/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualizationOGL2D;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import repast.simphony.visualizationOGL2D.SVGToBufferedImage;
import repast.simphony.visualizationOGL2D.SVGToNamedShape;
import repast.simphony.visualizationOGL2D.SpatialSource;
import saf.v3d.ShapeFactory2D;

public class SVGSpatialSource
implements SpatialSource {
    private static final String SIMPLE = "simple";
    private String id;
    private String path;
    protected boolean simple = false;

    public SVGSpatialSource(String id, String path) throws IOException {
        this.id = id;
        this.path = path;
        this.parseProps(path);
    }

    protected void parseProps(String path) throws IOException {
        String uri;
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
        SVGOMDocument doc = (SVGOMDocument)f.createDocument(uri = new File(path).toURI().toString());
        NodeList nodes = doc.getElementsByTagName("dc:subject");
        if (nodes.getLength() > 0) {
            nodes = ((Element)nodes.item(0)).getElementsByTagName("rdf:li");
            int i = 0;
            while (i < nodes.getLength()) {
                if (nodes.item(i).getNodeType() == 1) {
                    Element item = (Element)nodes.item(i);
                    this.parseProperty(item.getTextContent().trim());
                }
                ++i;
            }
        }
    }

    private void parseProperty(String text) throws IOException {
        if (text.equals(SIMPLE)) {
            this.simple = true;
        }
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void registerSource(ShapeFactory2D shapeFactory, Map<String, String> props) throws IOException {
        if (this.simple) {
            this.registerShape(shapeFactory, props);
        } else {
            this.registerImage(shapeFactory, props);
        }
    }

    private void registerShape(ShapeFactory2D shapeFactory, Map<String, String> props) throws IOException {
        SVGToNamedShape shaper = new SVGToNamedShape(this.path, this.id, props);
        shaper.createShape(shapeFactory);
    }

    private void registerImage(ShapeFactory2D shapeFactory, Map<String, String> props) throws IOException {
        try {
            int width = -1;
            int height = -1;
            if (props.containsKey("bsq_size")) {
                int size = Integer.parseInt(props.get("bsq_size"));
                BufferedImage img = SVGToBufferedImage.createImage(this.path, -1, -1);
                float imgWidth = img.getWidth();
                float imgHeight = img.getHeight();
                img = null;
                if (imgWidth > imgHeight) {
                    width = size;
                    float scale = (float)size / imgWidth;
                    height = (int)(imgHeight * scale);
                } else {
                    height = size;
                    float scale = (float)size / imgHeight;
                    width = (int)(imgWidth * scale);
                }
            } else {
                if (props.containsKey("width")) {
                    width = Integer.parseInt(props.get("width"));
                }
                if (props.containsKey("height")) {
                    width = Integer.parseInt(props.get("height"));
                }
            }
            BufferedImage img = SVGToBufferedImage.createImage(this.path, width, height);
            float scale = 1.0f;
            if (props.containsKey("scale")) {
                scale = Float.parseFloat(props.get("scale"));
            }
            shapeFactory.registerImage(this.id, img, scale);
        }
        catch (TranscoderException ex) {
            throw new IOException(ex);
        }
        catch (NumberFormatException ex) {
            throw new IOException("Invalid bbox size, width, height or scale in properties", ex);
        }
    }
}

