/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualizationOGL2D;

import java.awt.Color;
import java.util.concurrent.locks.Lock;
import repast.simphony.space.graph.Network;
import repast.simphony.space.graph.RepastEdge;
import repast.simphony.space.projection.ProjectionEvent;
import repast.simphony.space.projection.ProjectionListener;
import repast.simphony.visualization.LayoutUpdater;
import repast.simphony.visualizationOGL2D.AbstractDisplayLayerOGL2D;
import repast.simphony.visualizationOGL2D.DisplayOGL2D;
import repast.simphony.visualizationOGL2D.EdgeStyleOGL2D;
import saf.v3d.AppearanceFactory;
import saf.v3d.scene.Appearance;
import saf.v3d.scene.VEdge2D;
import saf.v3d.scene.VEdgeLayer;
import saf.v3d.scene.VLayer;
import saf.v3d.scene.VSpatial;

public class NetworkLayerOGL2D
extends AbstractDisplayLayerOGL2D<EdgeStyleOGL2D>
implements ProjectionListener {
    private boolean isDirected;
    private DisplayOGL2D display;

    public NetworkLayerOGL2D(Network<?> network, EdgeStyleOGL2D style, VLayer layer, DisplayOGL2D display) {
        super(style, (VLayer)new VEdgeLayer());
        layer.addChild((VSpatial)this.layer);
        this.isDirected = network.isDirected();
        network.addProjectionListener((ProjectionListener)this);
        this.display = display;
        for (RepastEdge edge : network.getEdges()) {
            this.addObject(edge);
        }
    }

    public void projectionEventOccurred(ProjectionEvent evt) {
        if (evt.getType() == ProjectionEvent.EDGE_ADDED) {
            Lock lock = this.display.getRenderLock();
            try {
                lock.lock();
                this.addObject((RepastEdge)evt.getSubject());
            }
            finally {
                lock.unlock();
            }
        }
        if (evt.getType() == ProjectionEvent.EDGE_REMOVED) {
            Lock lock = this.display.getRenderLock();
            try {
                lock.lock();
                this.removeObject((RepastEdge)evt.getSubject());
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void applyStyle(RepastEdge edge, VEdge2D item) {
        item.setAppearance((Appearance)AppearanceFactory.createColorAppearance((Color)((EdgeStyleOGL2D)this.style).getColor(edge)));
        item.setEdgeWidth(((EdgeStyleOGL2D)this.style).getLineWidth(edge));
    }

    @Override
    public void update(LayoutUpdater updater) {
        RepastEdge rEdge;
        for (Object obj : this.toBeRemoved) {
            VEdge2D item = (VEdge2D)this.objMap.remove(obj);
            this.layer.removeChild((VSpatial)item);
        }
        this.toBeRemoved.clear();
        for (VSpatial item : this.layer.children()) {
            rEdge = (RepastEdge)item.getProperty((Object)"DisplayLayerOGL2D.MODEL_OBJECT_KEY");
            VEdge2D edge = (VEdge2D)item;
            this.applyStyle(rEdge, edge);
            edge.update();
        }
        for (Object obj : this.toBeAdded) {
            rEdge = (RepastEdge)obj;
            VSpatial source = this.display.getSpatialForObject(rEdge.getSource());
            VSpatial target = this.display.getSpatialForObject(rEdge.getTarget());
            VEdge2D edge = new VEdge2D(source, target, this.isDirected);
            edge.putProperty((Object)"DisplayLayerOGL2D.MODEL_OBJECT_KEY", obj);
            this.objMap.put(rEdge, edge);
            this.applyStyle(rEdge, edge);
            this.layer.addChild((VSpatial)edge);
        }
        this.toBeAdded.clear();
    }
}

