/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualizationOGL2D;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;
import repast.simphony.visualizationOGL2D.SpatialSource;
import saf.v3d.ShapeFactory2D;

public class ImageSpatialSource
implements SpatialSource {
    private String id;
    private String path;

    public ImageSpatialSource(String id, String path) throws IOException {
        this.id = id;
        this.path = path;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void registerSource(ShapeFactory2D shapeFactory, Map<String, String> props) throws IOException {
        BufferedImage img = ImageIO.read(new File(this.path));
        int imgWidth = img.getWidth();
        int imgHeight = img.getHeight();
        int width = imgWidth;
        int height = imgHeight;
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        if (props.containsKey("bsq_size")) {
            int size = Integer.parseInt(props.get("bsq_size"));
            if (imgWidth > imgHeight) {
                width = size;
                scaleX = (float)size / (float)imgWidth;
                height = (int)((float)imgHeight * scaleX);
                scaleY = (float)height / (float)imgHeight;
            } else {
                height = size;
                scaleY = (float)size / (float)imgHeight;
                width = (int)((float)imgWidth * scaleY);
                scaleX = (float)width / (float)imgWidth;
            }
        } else {
            if (props.containsKey("width")) {
                width = (int)Double.parseDouble(props.get("width"));
            }
            if (props.containsKey("height")) {
                height = (int)Double.parseDouble(props.get("height"));
            }
            if (width != imgWidth) {
                scaleX = (float)width / (float)imgWidth;
                if (height != imgHeight) {
                    scaleY = (float)height / (float)imgHeight;
                } else {
                    scaleY = scaleX;
                    height = (int)((float)imgHeight * scaleY);
                }
            } else if (height != imgHeight) {
                scaleX = scaleY = (float)height / (float)imgHeight;
                width = (int)((float)imgWidth * scaleX);
            }
        }
        if (scaleX != 1.0f || scaleY != 1.0f) {
            BufferedImage scaledImg = new BufferedImage(width, height, img.getType());
            AffineTransform at = AffineTransform.getScaleInstance(scaleX, scaleY);
            Graphics2D graphics = scaledImg.createGraphics();
            graphics.drawRenderedImage(img, at);
            graphics.dispose();
            img = scaledImg;
        }
        float scale = 1.0f;
        if (props.containsKey("scale")) {
            scale = Float.parseFloat(props.get("scale"));
        }
        shapeFactory.registerImage(this.id, img, scale);
    }
}

