/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualizationOGL2D;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import javax.media.opengl.GLAutoDrawable;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Point3f;
import org.apache.commons.lang3.SystemUtils;
import repast.simphony.space.graph.Network;
import repast.simphony.space.projection.Projection;
import repast.simphony.space.projection.ProjectionListener;
import repast.simphony.ui.Imageable;
import repast.simphony.valueLayer.ValueLayer;
import repast.simphony.visualization.AbstractDisplay;
import repast.simphony.visualization.AddedRemovedLayoutUpdater;
import repast.simphony.visualization.Box;
import repast.simphony.visualization.DisplayData;
import repast.simphony.visualization.DisplayEditorLifecycle;
import repast.simphony.visualization.IDisplay;
import repast.simphony.visualization.IntervalLayoutUpdater;
import repast.simphony.visualization.Layout;
import repast.simphony.visualization.LayoutUpdater;
import repast.simphony.visualization.MovedLayoutUpdater;
import repast.simphony.visualization.UpdateLayoutUpdater;
import repast.simphony.visualization.decorator.ProjectionDecorator2D;
import repast.simphony.visualizationOGL2D.EdgeStyleOGL2D;
import repast.simphony.visualizationOGL2D.NetworkLayerOGL2D;
import repast.simphony.visualizationOGL2D.StyleOGL2D;
import repast.simphony.visualizationOGL2D.StyledDisplayLayerOGL2D;
import repast.simphony.visualizationOGL2D.ValueLayerDisplayLayer;
import repast.simphony.visualizationOGL2D.ValueLayerStyleOGL;
import saf.v3d.Canvas2D;
import saf.v3d.CanvasListener;
import saf.v3d.picking.PickEvent;
import saf.v3d.picking.PickListener;
import saf.v3d.scene.VComposite;
import saf.v3d.scene.VLayer;
import saf.v3d.scene.VRoot;
import saf.v3d.scene.VSpatial;
import simphony.util.ThreadUtilities;
import simphony.util.messages.MessageCenter;

public class DisplayOGL2D
extends AbstractDisplay
implements CanvasListener,
PickListener,
ChangeListener {
    private Runnable updater = new Runnable(){

        @Override
        public void run() {
            DisplayOGL2D.this.canvas.update();
        }
    };
    private Layout<?, ?> layout;
    private Canvas2D canvas;
    private DisplayData<?> displayData;
    private Map<Class<?>, StyledDisplayLayerOGL2D> classStyleMap = new HashMap();
    private Map<Network<?>, NetworkLayerOGL2D> networkStyleMap = new HashMap();
    private Map<ValueLayer, ValueLayerDisplayLayer> valueLayerStyleMap = new HashMap<ValueLayer, ValueLayerDisplayLayer>();
    private Map<String, ProjectionDecorator2D<?>> decoratorMap = new HashMap();
    private LayoutUpdater layoutUpdater;
    private boolean doRender = false;
    private boolean glInitialized = false;
    private boolean iconified = false;
    private JTabbedPane tabParent = null;
    private Component tabChild = null;
    private VLayer decoratorLayer = new VLayer();

    static {
        System.setProperty("sun.awt.noerasebackground", "true");
    }

    public DisplayOGL2D(DisplayData<?> data, Layout<?, ?> layout) {
        this.layout = layout;
        try {
            this.canvas = new Canvas2D();
        }
        catch (Exception ex) {
            MessageCenter.getMessageCenter(this.getClass()).error((Object)"Error initializing OGL 2D display. JOGL must be installed and computer must support open gl rendering", (Throwable)ex, new Object[0]);
        }
        Box box = layout.getBoundingBox();
        if (box.getWidth() > 0.0f) {
            this.canvas.setDefaultExtent(box.getWidth(), box.getHeight());
        }
        this.canvas.addCanvasListener((CanvasListener)this);
        this.canvas.addPickListener((PickListener)this);
        this.canvas.getRoot().addChild((VSpatial)this.decoratorLayer);
        this.displayData = data;
        this.layoutUpdater = new UpdateLayoutUpdater(layout);
    }

    Lock getRenderLock() {
        return this.canvas.getRenderLock();
    }

    public void init() {
        boolean decoAdded = false;
        for (Projection proj : this.displayData.getProjections()) {
            proj.addProjectionListener((ProjectionListener)this);
            ProjectionDecorator2D<?> deco = this.decoratorMap.get(proj.getName());
            if (deco == null) continue;
            deco.init(this, (VComposite)this.decoratorLayer);
            decoAdded = true;
        }
        if (!decoAdded) {
            this.canvas.getRoot().removeChild((VSpatial)this.decoratorLayer);
        }
        for (Object obj : this.displayData.objects()) {
            this.addObject(obj);
        }
    }

    public void setBackgroundColor(Color color) {
        this.canvas.setBackgroundColor(color);
    }

    public Color getBackgroundColor() {
        return this.canvas.getBackgroundColor();
    }

    @Override
    protected void moveObject(Object o) {
        this.layoutUpdater.addTriggerCondition(LayoutUpdater.Condition.MOVED);
    }

    @Override
    protected void addObject(Object o) {
        StyledDisplayLayerOGL2D layer = this.findLayer(o);
        if (layer != null) {
            Lock lock = this.canvas.getRenderLock();
            try {
                lock.lock();
                layer.addObject(o);
                this.layoutUpdater.addTriggerCondition(LayoutUpdater.Condition.ADDED);
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Override
    protected void removeObject(Object o) {
        StyledDisplayLayerOGL2D layer = this.findLayer(o);
        if (layer != null) {
            Lock lock = this.canvas.getRenderLock();
            try {
                lock.lock();
                layer.removeObject(o);
                this.layoutUpdater.addTriggerCondition(LayoutUpdater.Condition.REMOVED);
            }
            finally {
                lock.unlock();
            }
        }
    }

    public void closed() {
    }

    public DisplayEditorLifecycle createEditor(JPanel panel) {
        return null;
    }

    public void deIconified() {
        this.iconified = false;
    }

    public void iconified() {
        this.iconified = true;
    }

    public void resetHomeView() {
        this.canvas.resetCamera();
        this.canvas.centerScene();
        ThreadUtilities.runInEventThread((Runnable)this.updater);
    }

    public Layout<?, ?> getLayout() {
        return this.layout;
    }

    public JPanel getPanel() {
        JPanel panel = this.canvas.getPanel();
        ImageablePanel iPanel = new ImageablePanel(new BorderLayout());
        iPanel.add((Component)panel, "Center");
        panel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (DisplayOGL2D.this.glInitialized && DisplayOGL2D.this.isVisible()) {
                    DisplayOGL2D.this.canvas.update();
                }
            }
        });
        panel.addPropertyChangeListener("ancestor", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Container child = DisplayOGL2D.this.canvas.getPanel();
                Container parent = child.getParent();
                while (parent != null) {
                    if (parent instanceof JTabbedPane) {
                        DisplayOGL2D.this.tabParent = (JTabbedPane)parent;
                        DisplayOGL2D.this.tabChild = child;
                        return;
                    }
                    child = parent;
                    parent = parent.getParent();
                }
                DisplayOGL2D.this.tabParent = null;
                DisplayOGL2D.this.tabChild = null;
            }
        });
        return iPanel;
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        if (this.tabParent.getSelectedComponent().equals(this.tabChild)) {
            this.canvas.centerScene();
            this.canvas.update();
        }
    }

    private boolean isVisible() {
        if (this.iconified) {
            return false;
        }
        if (this.tabParent != null) {
            return this.tabParent.getSelectedComponent().equals(this.tabChild);
        }
        return true;
    }

    public void setLayout(Layout<?, ?> layout) {
        this.layout = layout;
        this.layoutUpdater.setLayout(layout);
    }

    public void setLayoutFrequency(IDisplay.LayoutFrequency frequency, int interval) {
        if (frequency == IDisplay.LayoutFrequency.AT_UPDATE) {
            this.layoutUpdater = new UpdateLayoutUpdater(this.layout);
        } else if (frequency == IDisplay.LayoutFrequency.AT_INTERVAL) {
            this.layoutUpdater = new IntervalLayoutUpdater(this.layout, interval);
        } else if (frequency == IDisplay.LayoutFrequency.ON_NEW) {
            this.layoutUpdater = new AddedRemovedLayoutUpdater(this.layout);
        } else if (frequency == IDisplay.LayoutFrequency.ON_MOVE) {
            this.layoutUpdater = new MovedLayoutUpdater(this.layout);
        }
    }

    public void setPause(boolean pause) {
        if (pause) {
            this.update();
            this.render();
        }
        ThreadUtilities.runInEventThread((Runnable)this.updater);
    }

    public void update() {
        if (this.glInitialized && !this.iconified) {
            this.layoutUpdater.update();
            try {
                this.canvas.getRenderLock().lock();
                for (ValueLayerDisplayLayer valueLayerDisplayLayer : this.valueLayerStyleMap.values()) {
                    valueLayerDisplayLayer.update();
                }
                for (StyledDisplayLayerOGL2D styledDisplayLayerOGL2D : this.classStyleMap.values()) {
                    styledDisplayLayerOGL2D.update(this.layoutUpdater);
                }
                for (NetworkLayerOGL2D networkLayerOGL2D : this.networkStyleMap.values()) {
                    networkLayerOGL2D.update(this.layoutUpdater);
                }
                this.doRender = true;
            }
            finally {
                this.canvas.getRenderLock().unlock();
            }
        }
    }

    public void render() {
        long ts = System.currentTimeMillis();
        if (this.doRender && !this.iconified) {
            if (ts - this.lastRenderTS > FRAME_UPDATE_INTERVAL) {
                ThreadUtilities.runInEventThread((Runnable)this.updater);
                this.lastRenderTS = ts;
            }
            this.doRender = false;
        }
    }

    public void registerDecorator(ProjectionDecorator2D<?> decorator) {
        this.decoratorMap.put(((Projection)decorator.getProjection()).getName(), decorator);
    }

    protected StyledDisplayLayerOGL2D findLayer(Object obj) {
        Class<?> objClass = obj.getClass();
        StyledDisplayLayerOGL2D layer = this.classStyleMap.get(objClass);
        if (layer == null) {
            for (Class<?> clazz : this.classStyleMap.keySet()) {
                if (!clazz.isAssignableFrom(objClass)) continue;
                layer = this.classStyleMap.get(clazz);
                break;
            }
        }
        return layer;
    }

    public void registerStyle(Class<?> clazz, StyleOGL2D<?> style) {
        style.init(this.canvas.getShapeFactory());
        StyledDisplayLayerOGL2D layer = this.classStyleMap.get(clazz);
        if (layer == null) {
            VLayer vLayer = new VLayer();
            this.canvas.getRoot().addChild((VSpatial)vLayer);
            layer = new StyledDisplayLayerOGL2D(style, vLayer);
            this.classStyleMap.put(clazz, layer);
        } else {
            layer.setStyle(style);
        }
    }

    public void registerNetworkStyle(Network<?> network, EdgeStyleOGL2D style) {
        NetworkLayerOGL2D layer = this.networkStyleMap.get(network);
        if (layer == null) {
            VLayer vLayer = new VLayer();
            this.canvas.getRoot().addChild((VSpatial)vLayer);
            layer = new NetworkLayerOGL2D(network, style, vLayer, this);
            this.networkStyleMap.put(network, layer);
        } else {
            layer.setStyle(style);
        }
    }

    public void registerValueLayerStyle(ValueLayer layer, ValueLayerStyleOGL style) {
        ValueLayerDisplayLayer vdLayer = this.valueLayerStyleMap.get(layer);
        if (vdLayer == null) {
            VLayer vLayer = new VLayer();
            this.canvas.getRoot().addChild((VSpatial)vLayer);
            vdLayer = new ValueLayerDisplayLayer(layer, style, vLayer);
            this.valueLayerStyleMap.put(layer, vdLayer);
        } else {
            vdLayer.resetLayer(layer, style);
        }
    }

    VSpatial getSpatialForObject(Object obj) {
        StyledDisplayLayerOGL2D layer = this.findLayer(obj);
        return layer.getVisualItem(obj);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.canvas.dispose();
        for (Projection proj : this.displayData.getProjections()) {
            proj.removeProjectionListener((ProjectionListener)this);
        }
        this.displayData = null;
    }

    public void pickPerformed(PickEvent evt) {
        ArrayList<Object> probedObjects = new ArrayList<Object>();
        for (VSpatial spatial : evt.getPicked()) {
            Object obj = spatial.getProperty((Object)"DisplayLayerOGL2D.MODEL_OBJECT_KEY");
            if (obj == null) continue;
            if (spatial.getProperty((Object)"ValueLayerDisplayLayer.ValueLayerKey") != null) {
                obj = ((ValueLayerDisplayLayer)spatial.getProperty((Object)"ValueLayerDisplayLayer.ValueLayerKey")).getProbedObject();
            }
            probedObjects.add(obj);
        }
        this.probeSupport.fireProbeEvent((Object)this, probedObjects);
    }

    public void init(GLAutoDrawable drawable, VRoot root) {
    }

    public void reshape(GLAutoDrawable drawable, float width, float height, VRoot root) {
        this.glInitialized = true;
        this.update();
    }

    public void vSpatialMoved(VSpatial spatial, Point3f localTrans) {
    }

    public void dispose(GLAutoDrawable drawable) {
    }

    class ImageablePanel
    extends JPanel
    implements Imageable {
        public ImageablePanel(LayoutManager layout) {
            super(layout);
        }

        public BufferedImage getImage() {
            try {
                DisplayOGL2D.this.getRenderLock().lock();
                if (SystemUtils.IS_OS_WINDOWS) {
                    BufferedImage bufferedImage = DisplayOGL2D.this.canvas.createImage();
                    return bufferedImage;
                }
                BufferedImage bi = new BufferedImage(this.getWidth(), this.getHeight(), 2);
                Graphics2D g = bi.createGraphics();
                this.paint(g);
                g.dispose();
                BufferedImage bufferedImage = bi;
                return bufferedImage;
            }
            finally {
                DisplayOGL2D.this.getRenderLock().unlock();
            }
        }
    }
}

