/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.visualization3D.layout;

import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.visualization.util.ChangeEventSupport;
import edu.uci.ics.jung.visualization.util.DefaultChangeEventSupport;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeListener;
import repast.simphony.space.graph.Network;
import repast.simphony.space.graph.RepastEdge;
import repast.simphony.visualization.AbstractNetworkLayout;
import repast.simphony.visualization.visualization3D.layout.JungRandomVertexLocationDecorator;
import repast.simphony.visualization.visualization3D.layout.JungVertexLocationFunction;

public abstract class JungNetworkLayout<T>
extends AbstractNetworkLayout<T>
implements ChangeEventSupport {
    protected List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    protected ChangeEventSupport changeSupport = new DefaultChangeEventSupport((Object)this);
    protected Set dontmove;
    private static final Object BASE_KEY = "edu.uci.ics.jung.Base_Visualization_Key";
    private Dimension currentSize;
    protected Network visibleGraph;
    protected JungVertexLocationFunction vertex_locations;
    protected Set<Object> visibleVertices;
    protected Set<Object> visibleEdges;
    private Object key;
    protected Map<Object, Object> objectData;
    protected int xSize;
    protected int ySize;

    public boolean dontMove(Object o) {
        return this.dontmove.contains(o);
    }

    public void initialize(Dimension size) {
        this.initialize(size, new JungRandomVertexLocationDecorator(size));
    }

    public void initialize(Dimension size, JungVertexLocationFunction v_locations) {
        this.currentSize = size;
        this.vertex_locations = v_locations;
        this.initialize_local();
        this.initializeLocations();
    }

    protected void initialize_local() {
    }

    protected void postInitialize() {
    }

    protected abstract void initialize_local_vertex(Object var1);

    public Object getBaseKey() {
        if (this.key == null) {
            try {
                this.key = new Pair((Object)this, BASE_KEY);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.key;
    }

    protected void initializeLocations() {
        try {
            for (Object o : this.baseGraph.getNodes()) {
                double[] coord = this.returnMatchingCoordinate(o);
                if (coord == null) {
                    coord = new double[2];
                    this.locationData.put(o, coord);
                }
                if (!this.dontmove.contains(o)) {
                    this.initializeLocation(o, coord, this.currentSize);
                }
                this.initialize_local_vertex(o);
            }
        }
        catch (ConcurrentModificationException cme) {
            this.initializeLocations();
        }
    }

    public double[] returnMatchingCoordinate(Object o) {
        double[] coordinate = (double[])this.locationData.get(o);
        return coordinate;
    }

    protected void initializeLocation(Object o, double[] coord, Dimension d) {
        this.locationData.put(o, this.vertex_locations.getLocation(o));
    }

    public String getStatus() {
        return null;
    }

    @Override
    public void update() {
        this.initializeLocations();
    }

    public abstract void advancePositions();

    protected Network getVisibleGraph() {
        return this.visibleGraph;
    }

    public Dimension getCurrentSize() {
        return this.currentSize;
    }

    protected Object getAVertex(RepastEdge e) {
        Object vertex = null;
        for (Object v : this.visibleVertices) {
            if (e.getSource() == v) {
                vertex = v;
                continue;
            }
            if (e.getTarget() != v) continue;
            vertex = v;
        }
        return vertex;
    }

    public double[] getCoordinates(Object o) {
        double[] coordinates = (double[])this.locationData.get(o);
        return coordinates;
    }

    public double getX(Object o) {
        double[] coordinates = (double[])this.locationData.get(o);
        return coordinates[0];
    }

    public double getY(Object o) {
        double[] coordinates = (double[])this.locationData.get(o);
        return coordinates[1];
    }

    public float[] getLocation(Object obj) {
        double[] coordinates = (double[])this.locationData.get(obj);
        float[] coords = null;
        if (coordinates == null) {
            coordinates = this.vertex_locations.getLocation(obj);
        }
        coords = new float[coordinates.length];
        int i = 0;
        while (i < coordinates.length) {
            coords[i] = (float)coordinates[i];
            ++i;
        }
        return coords;
    }

    public float[] getLocation(Object obj, boolean threeD) {
        double[] coordinates = (double[])this.locationData.get(obj);
        float[] coords = null;
        if (coordinates == null) {
            coordinates = this.vertex_locations.getLocation(obj, true);
        }
        coords = new float[coordinates.length];
        int i = 0;
        while (i < coordinates.length) {
            coords[i] = (float)coordinates[i];
            ++i;
        }
        return coords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(Dimension size) {
        Dimension oldSize;
        if (this.currentSize == null) {
            this.currentSize = size;
            return;
        }
        Dimension dimension = this.currentSize;
        synchronized (dimension) {
            if (this.currentSize.equals(size)) {
                return;
            }
            oldSize = this.currentSize;
            this.currentSize = size;
        }
        int xOffset = (size.width - oldSize.width) / 2;
        int yOffset = (size.height - oldSize.height) / 2;
        while (true) {
            try {
                for (Object o : this.getGraph().getNodes()) {
                    this.offsetVertex(o, xOffset, yOffset);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
    }

    protected void offsetVertex(Object o, double xOffset, double yOffset) {
        double[] coordinates = this.getCoordinates(o);
        coordinates[0] = xOffset + coordinates[0];
        coordinates[1] = yOffset + coordinates[1];
        this.forceMove(o, coordinates[0], coordinates[1]);
    }

    public void restart() {
        this.initialize_local();
        this.initializeLocations();
    }

    public Object getVertex(double x, double y) {
        return this.getVertex(x, y, Math.sqrt(Double.MAX_VALUE));
    }

    public Object getVertex(double x, double y, double maxDistance) {
        double minDistance = maxDistance * maxDistance;
        Object closest = null;
        while (true) {
            try {
                for (Object o : this.getVisibleVertices()) {
                    double dy;
                    double[] location = this.getCoordinates(o);
                    double dx = location[0] - x;
                    double dist = dx * dx + (dy = location[1] - y) * dy;
                    if (!(dist < minDistance)) continue;
                    minDistance = dist;
                    closest = o;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return closest;
    }

    public RepastEdge getEdge(double x, double y) {
        return this.getEdge(x, y, Math.sqrt(Double.MAX_VALUE));
    }

    public RepastEdge getEdge(double x, double y, double maxDistance) {
        double minDistance = maxDistance * maxDistance;
        RepastEdge closest = null;
        while (true) {
            try {
                for (RepastEdge e : this.getVisibleEdges()) {
                    double distance2;
                    if (e.getSource() != null && e.getTarget() != null) continue;
                    Set vertices = this.getVerticesFromEdge(e);
                    Iterator vertexIterator = vertices.iterator();
                    Object v1 = vertexIterator.next();
                    Object v2 = vertexIterator.next();
                    double[] location1 = this.getCoordinates(v1);
                    double[] location2 = this.getCoordinates(v2);
                    double x1 = location1[0];
                    double y1 = location1[1];
                    double x2 = location2[0];
                    double y2 = location2[1];
                    if (x1 == x2 && y1 == y2) continue;
                    double b = ((y - y1) * (y2 - y1) + (x - x1) * (x2 - x1)) / ((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
                    if (b <= 0.0) {
                        distance2 = (x - x1) * (x - x1) + (y - y1) * (y - y1);
                    } else if (b >= 1.0) {
                        distance2 = (x - x2) * (x - x2) + (y - y2) * (y - y2);
                    } else {
                        double x3 = x1 + b * (x2 - x1);
                        double y3 = y1 + b * (y2 - y1);
                        distance2 = (x - x3) * (x - x3) + (y - y3) * (y - y3);
                    }
                    if (!(distance2 < minDistance)) continue;
                    minDistance = distance2;
                    closest = e;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return closest;
    }

    @Override
    public Network getGraph() {
        return super.getGraph();
    }

    public Set getVisibleEdges() {
        return this.visibleEdges;
    }

    public Set getVisibleVertices() {
        return this.visibleVertices;
    }

    public void forceMove(Object picked, double x, double y) {
        double[] coord = this.getCoordinates(picked);
        coord[0] = x;
        coord[1] = y;
        this.fireStateChanged();
    }

    public void forceMove(Object picked, double x, double y, double z) {
        double[] coord = this.getCoordinates(picked);
        coord[0] = x;
        coord[1] = y;
        coord[2] = z;
        this.fireStateChanged();
    }

    public void lockVertex(Object o) {
        this.dontmove.add(o);
    }

    public void unlockVertex(Object o) {
        this.dontmove.remove(o);
    }

    public void applyFilter(Network n) {
        this.visibleGraph = n;
        Set<Object> thisVertices = this.addEdgesOrVertices(n.getNodes());
        Set<Object> thisEdges = this.addEdgesOrVertices(n.getEdges());
        Set<Object> thatVertices = this.addEdgesOrVertices(this.baseGraph.getNodes());
        Set<Object> thatEdges = this.addEdgesOrVertices(this.baseGraph.getEdges());
        this.visibleVertices = this.returnEqualSet(thisVertices, thatVertices);
        this.visibleEdges = this.returnEqualSet(thisEdges, thatEdges);
    }

    public void addChangeListener(ChangeListener arg0) {
        this.changeListeners.add(arg0);
    }

    public void removeChangeListener(ChangeListener arg0) {
        this.changeListeners.remove(arg0);
    }

    public ChangeListener[] getChangeListeners() {
        ChangeListener[] changeListenerArray = (ChangeListener[])this.changeListeners.toArray();
        return changeListenerArray;
    }

    public void fireStateChanged() {
        this.changeSupport.fireStateChanged();
    }

    public Set returnEqualSet(Set<Object> thisVertices, Set<Object> thatVertices) {
        HashSet<Object> equalVertices = new HashSet<Object>();
        for (Object o : thisVertices) {
            if (!thatVertices.contains(o)) continue;
            equalVertices.add(o);
        }
        return equalVertices;
    }

    private Set getVerticesFromEdge(RepastEdge e) {
        HashSet<Object> set = new HashSet<Object>();
        Object s = e.getSource();
        Object t = e.getTarget();
        set.add(s);
        set.add(t);
        return set;
    }

    protected Set<Object> addEdgesOrVertices(Iterable it) {
        HashSet<Object> objects = new HashSet<Object>();
        for (Object o : it) {
            objects.add(o);
        }
        return objects;
    }

    private Set<RepastEdge> addEdges(Iterable<RepastEdge> it) {
        HashSet<RepastEdge> objects = new HashSet<RepastEdge>();
        for (RepastEdge re : it) {
            objects.add(re);
        }
        return objects;
    }

    @Override
    public void setProjection(Network projection) {
        this.baseGraph = projection;
        this.visibleGraph = projection;
        Iterable edges = projection.getEdges();
        this.visibleEdges = this.addEdgesOrVertices(edges);
        Iterable nodes = projection.getNodes();
        this.visibleVertices = this.addEdgesOrVertices(nodes);
        this.dontmove = new HashSet();
        this.locationData = new HashMap();
        this.objectData = new HashMap<Object, Object>();
        this.currentSize = new Dimension(3200, 1600);
        this.initialize(this.currentSize);
    }

    public void resetVisibleEdgesAndVertices() {
        Iterable edges = this.baseGraph.getEdges();
        Iterable vertices = this.baseGraph.getNodes();
        this.visibleEdges = this.addEdgesOrVertices(edges);
        this.visibleVertices = this.addEdgesOrVertices(vertices);
    }

    public int getXSize() {
        return this.xSize;
    }

    public void setXSize(int size) {
        this.xSize = size;
    }

    public int getYSize() {
        return this.ySize;
    }

    public void setYSize(int size) {
        this.ySize = size;
    }

    @Override
    public String getName() {
        return super.getName();
    }
}

