/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.visualization3D;

import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.picking.PickTool;
import java.awt.Color;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Point3f;

public class ShapeFactory {
    public static Shape3D createSphere(float radius, int divisions, Object id, int primFlags, Appearance appearance) {
        Sphere sphere = new Sphere(radius, primFlags, divisions, null);
        Shape3D shape = new Shape3D(sphere.getShape().getGeometry(), appearance);
        shape.setCapability(14);
        shape.setCapability(15);
        shape.setCapability(12);
        Geometry geom = shape.getGeometry();
        if (!geom.isLive() && !geom.isCompiled()) {
            PickTool.setCapabilities((Node)shape, (int)4100);
        }
        shape.setUserData(id);
        return shape;
    }

    public static Shape3D createSphere(float radius, Object id) {
        return ShapeFactory.createSphere(radius, 15, id, 1, null);
    }

    public static Shape3D createCube(float edgeLength, Object id) {
        return ShapeFactory.createBox(edgeLength, edgeLength, edgeLength, id, 1, null);
    }

    public static Shape3D createArrowHead(float height, Object id) {
        LineArray la = new LineArray(4, 1);
        float halfHeight = height / 2.0f;
        la.setCoordinate(0, new Point3f(-halfHeight / 2.0f, -halfHeight, 0.0f));
        la.setCoordinate(1, new Point3f(0.0f, halfHeight, 0.0f));
        la.setCoordinate(2, new Point3f(0.0f, halfHeight, 0.0f));
        la.setCoordinate(3, new Point3f(halfHeight / 2.0f, -halfHeight, 0.0f));
        Shape3D shape = new Shape3D((Geometry)la);
        if (!la.isLive() && !la.isCompiled()) {
            PickTool.setCapabilities((Node)shape, (int)4100);
        }
        shape.setCapability(14);
        shape.setCapability(15);
        shape.setCapability(12);
        shape.setUserData(id);
        return shape;
    }

    public static Shape3D createLine(float length, Object id) {
        LineArray la = new LineArray(2, 1);
        la.setCapability(1);
        la.setCapability(0);
        la.setCoordinate(0, new Point3f(0.0f, -(length / 2.0f), 0.0f));
        la.setCoordinate(1, new Point3f(0.0f, length / 2.0f, 0.0f));
        Shape3D shape = new Shape3D((Geometry)la);
        if (!la.isLive() && !la.isCompiled()) {
            PickTool.setCapabilities((Node)shape, (int)4100);
        }
        shape.setCapability(14);
        shape.setCapability(15);
        shape.setCapability(12);
        shape.setCapability(13);
        shape.setUserData(id);
        return shape;
    }

    public static Shape3D createCylinder(float radius, float height, Object id) {
        return ShapeFactory.createCylinder(radius, height, id, 1, null);
    }

    public static Shape3D createCylinder(float radius, float height, Object id, int primFlags, Appearance appearance) {
        Cylinder cyl = new Cylinder(radius, height, primFlags, null);
        Shape3D shape = new Shape3D();
        int i = 0;
        while (i < 3) {
            Geometry geometry = cyl.getShape(i).getGeometry();
            shape.addGeometry(geometry);
            if (!geometry.isLive() && !geometry.isCompiled()) {
                PickTool.setCapabilities((Node)cyl.getShape(i), (int)4100);
            }
            ++i;
        }
        if (appearance != null) {
            shape.setAppearance(appearance);
        }
        shape.setCapability(14);
        shape.setCapability(15);
        shape.setCapability(12);
        shape.setUserData(id);
        return shape;
    }

    public static Shape3D createBox(float xdim, float ydim, float zdim, Object id, int primFlags, Appearance appearance) {
        Box box = new Box(xdim, ydim, zdim, primFlags, null);
        Shape3D shape = new Shape3D();
        int i = 0;
        while (i < 6) {
            Geometry geom = box.getShape(i).getGeometry();
            shape.addGeometry(geom);
            if (!geom.isLive() && !geom.isCompiled()) {
                PickTool.setCapabilities((Node)shape, (int)4100);
            }
            ++i;
        }
        if (appearance != null) {
            shape.setAppearance(appearance);
        }
        shape.setCapability(12);
        shape.setCapability(14);
        shape.setCapability(15);
        shape.setUserData(id);
        return shape;
    }

    public static Shape3D createCone(float radius, float height, Object id) {
        return ShapeFactory.createCone(radius, height, id, 1, null);
    }

    public static Shape3D createCone(float radius, float height, Object id, int primFlags, Appearance appearance) {
        Cone cone = new Cone(radius, height, primFlags, null);
        Shape3D shape = new Shape3D();
        int i = 0;
        while (i < 2) {
            Geometry geometry = cone.getShape(i).getGeometry();
            shape.addGeometry(geometry);
            if (!geometry.isLive() && !geometry.isCompiled()) {
                PickTool.setCapabilities((Node)cone.getShape(i), (int)4100);
            }
            ++i;
        }
        if (appearance != null) {
            shape.setAppearance(appearance);
        }
        shape.setCapability(14);
        shape.setCapability(15);
        shape.setCapability(12);
        shape.setUserData(id);
        return shape;
    }

    public static Shape3D createWireframeSquare(float unitSize, float xdim, float zdim, Color color) {
        LineArray lineArray = new LineArray(8, 13);
        int i = 0;
        float xExtent = xdim * unitSize;
        float zExtent = zdim * unitSize;
        lineArray.setCoordinate(i++, new Point3f(0.0f, 0.0f, 0.0f));
        lineArray.setCoordinate(i++, new Point3f(xExtent, 0.0f, 0.0f));
        lineArray.setCoordinate(i++, new Point3f(0.0f, 0.0f, 0.0f));
        lineArray.setCoordinate(i++, new Point3f(0.0f, 0.0f, zExtent));
        lineArray.setCoordinate(i++, new Point3f(0.0f, 0.0f, zExtent));
        lineArray.setCoordinate(i++, new Point3f(xExtent, 0.0f, zExtent));
        lineArray.setCoordinate(i++, new Point3f(xExtent, 0.0f, 0.0f));
        lineArray.setCoordinate(i++, new Point3f(xExtent, 0.0f, zExtent));
        Color4f color4f = new Color4f(color);
        int j = 0;
        while (j < i) {
            lineArray.setColor(j, color4f);
            ++j;
        }
        Shape3D shape3d = new Shape3D((Geometry)lineArray);
        Appearance appearance = new Appearance();
        shape3d.setAppearanceOverrideEnable(true);
        appearance.setTransparencyAttributes(new TransparencyAttributes(0, 1.0f));
        shape3d.setAppearance(appearance);
        return shape3d;
    }

    public static Shape3D createWireframeBox(float xdim, float ydim, float zdim, Color color, Object id) {
        LineArray lineArray = new LineArray(24, 5);
        int i = 0;
        lineArray.setCoordinate(i++, new Point3f(0.0f, 0.0f, 0.0f));
        lineArray.setCoordinate(i++, new Point3f(xdim, 0.0f, 0.0f));
        lineArray.setCoordinate(i++, new Point3f(0.0f, 0.0f, 0.0f));
        lineArray.setCoordinate(i++, new Point3f(0.0f, ydim, 0.0f));
        lineArray.setCoordinate(i++, new Point3f(0.0f, 0.0f, 0.0f));
        lineArray.setCoordinate(i++, new Point3f(0.0f, 0.0f, zdim));
        lineArray.setCoordinate(i++, new Point3f(xdim, 0.0f, 0.0f));
        lineArray.setCoordinate(i++, new Point3f(xdim, ydim, 0.0f));
        lineArray.setCoordinate(i++, new Point3f(xdim, 0.0f, 0.0f));
        lineArray.setCoordinate(i++, new Point3f(xdim, 0.0f, zdim));
        lineArray.setCoordinate(i++, new Point3f(xdim, ydim, 0.0f));
        lineArray.setCoordinate(i++, new Point3f(0.0f, ydim, 0.0f));
        lineArray.setCoordinate(i++, new Point3f(xdim, ydim, 0.0f));
        lineArray.setCoordinate(i++, new Point3f(xdim, ydim, zdim));
        lineArray.setCoordinate(i++, new Point3f(0.0f, ydim, 0.0f));
        lineArray.setCoordinate(i++, new Point3f(0.0f, ydim, zdim));
        lineArray.setCoordinate(i++, new Point3f(0.0f, 0.0f, zdim));
        lineArray.setCoordinate(i++, new Point3f(xdim, 0.0f, zdim));
        lineArray.setCoordinate(i++, new Point3f(0.0f, 0.0f, zdim));
        lineArray.setCoordinate(i++, new Point3f(0.0f, ydim, zdim));
        lineArray.setCoordinate(i++, new Point3f(xdim, 0.0f, zdim));
        lineArray.setCoordinate(i++, new Point3f(xdim, ydim, zdim));
        lineArray.setCoordinate(i++, new Point3f(xdim, ydim, zdim));
        lineArray.setCoordinate(i++, new Point3f(0.0f, ydim, zdim));
        Color3f colors = new Color3f(color);
        int j = 0;
        while (j < i) {
            lineArray.setColor(j, colors);
            ++j;
        }
        Shape3D shape = new Shape3D((Geometry)lineArray);
        shape.setUserData(id);
        return shape;
    }

    public static Shape3D createGrid(float cellSize, Color color, int ... dimensions) {
        if (dimensions.length == 2) {
            int xDim = dimensions[0];
            int yDim = dimensions[1];
            LineArray lineArray = new LineArray(xDim * 2 + yDim * 2 + 4, 5);
            float z = cellSize * (float)yDim;
            int index = 0;
            Color3f color3f = new Color3f(color);
            int i = 0;
            while (i <= xDim) {
                float x = (float)i * cellSize;
                lineArray.setCoordinate(index, new Point3f(x, 0.0f, 0.0f));
                lineArray.setColor(index, color3f);
                lineArray.setCoordinate(++index, new Point3f(x, 0.0f, z));
                lineArray.setColor(index, color3f);
                ++index;
                ++i;
            }
            float x = cellSize * (float)xDim;
            int i2 = 0;
            while (i2 <= yDim) {
                z = (float)i2 * cellSize;
                lineArray.setCoordinate(index, new Point3f(0.0f, 0.0f, z));
                lineArray.setColor(index, color3f);
                lineArray.setCoordinate(++index, new Point3f(x, 0.0f, z));
                lineArray.setColor(index, color3f);
                ++index;
                ++i2;
            }
            return new Shape3D((Geometry)lineArray);
        }
        int xDim = dimensions[0];
        int yDim = dimensions[1];
        int zDim = dimensions[2];
        int verts = ((xDim + 1) * 2 + (zDim + 1)) * 2 * (yDim + 1) + (xDim + 1) * (zDim + 1) * 2;
        LineArray lineArray = new LineArray(verts, 5);
        Color3f color3f = new Color3f(color);
        float zMax = cellSize * (float)zDim;
        float xMax = cellSize * (float)xDim;
        int index = 0;
        int i = 0;
        while (i <= yDim) {
            float y = (float)i * cellSize;
            int j = 0;
            while (j <= xDim) {
                float x = (float)j * cellSize;
                lineArray.setCoordinate(index, new Point3f(x, y, 0.0f));
                lineArray.setColor(index, color3f);
                lineArray.setCoordinate(++index, new Point3f(x, y, zMax));
                lineArray.setColor(index, color3f);
                ++index;
                ++j;
            }
            j = 0;
            while (j <= zDim) {
                float z = (float)j * cellSize;
                lineArray.setCoordinate(index, new Point3f(0.0f, y, z));
                lineArray.setColor(index, color3f);
                lineArray.setCoordinate(++index, new Point3f(xMax, y, z));
                lineArray.setColor(index, color3f);
                ++index;
                ++j;
            }
            ++i;
        }
        float yMax = cellSize * (float)yDim;
        int i3 = 0;
        while (i3 <= xDim) {
            float x = (float)i3 * cellSize;
            int j = 0;
            while (j <= zDim) {
                float z = (float)j * cellSize;
                lineArray.setCoordinate(index, new Point3f(x, 0.0f, z));
                lineArray.setColor(index, color3f);
                lineArray.setCoordinate(++index, new Point3f(x, yMax, z));
                lineArray.setColor(index, color3f);
                ++index;
                ++j;
            }
            ++i3;
        }
        return new Shape3D((Geometry)lineArray);
    }

    public static Shape3D createAxes(float width, float height, float depth, float maxAxisLength, Color color, Object id) {
        LineArray lineArray = new LineArray(6, 5);
        width = width < maxAxisLength ? width : maxAxisLength;
        height = height < maxAxisLength ? height : maxAxisLength;
        depth = depth < maxAxisLength ? depth : maxAxisLength;
        int i = 0;
        lineArray.setCoordinate(i++, new Point3f(0.0f, 0.0f, 0.0f));
        lineArray.setCoordinate(i++, new Point3f(width, 0.0f, 0.0f));
        lineArray.setCoordinate(i++, new Point3f(0.0f, 0.0f, 0.0f));
        lineArray.setCoordinate(i++, new Point3f(0.0f, height, 0.0f));
        lineArray.setCoordinate(i++, new Point3f(0.0f, 0.0f, 0.0f));
        lineArray.setCoordinate(i++, new Point3f(0.0f, 0.0f, depth));
        Color3f colors = new Color3f(color);
        int j = 0;
        while (j < i) {
            lineArray.setColor(j, colors);
            ++j;
        }
        Shape3D shape = new Shape3D((Geometry)lineArray);
        shape.setUserData(id);
        return shape;
    }
}

