/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.visualization3D;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import java.awt.Color;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.TriangleStripArray;
import repast.simphony.visualization.visualization3D.DataGeometry;
import repast.simphony.visualization.visualization3D.style.ValueLayerStyle3D;

public class MeshGridGeometry
implements DataGeometry {
    private Geometry geometry;
    private int rows;
    private int cols;
    private int rowsOffset;
    private int colsOffset;
    private float[] updateArray;
    private boolean applyNeeded = false;

    public MeshGridGeometry(int xDim, int zDim, int xOffset, int zOffset) {
        this.cols = xDim;
        this.rows = zDim;
        this.colsOffset = xOffset;
        this.rowsOffset = zOffset;
    }

    @Override
    public Geometry getGeometry(ValueLayerStyle3D style) {
        float swY;
        Color color;
        if (this.geometry != null) {
            return this.geometry;
        }
        int numCoords = this.rows * (this.cols + 1) * 2 * 3;
        float[] coordinates = new float[numCoords];
        float[] colors = new float[numCoords];
        this.updateArray = new float[this.rows * (this.cols + 1) * 2 * 4];
        int ci = 0;
        int row = 0;
        int n = this.rows - 1;
        while (row < n) {
            int col = 0;
            while (col < this.cols) {
                int nextRow = row + 1;
                float swY2 = style.getY(col - this.colsOffset, row - this.rowsOffset);
                float nwY = style.getY(col - this.colsOffset, nextRow - this.rowsOffset);
                coordinates[ci] = col;
                coordinates[ci + 1] = nwY;
                coordinates[ci + 2] = -(row + 1);
                coordinates[ci + 3] = col;
                coordinates[ci + 4] = swY2;
                coordinates[ci + 5] = -row;
                color = (Color)style.getPaint(col - this.colsOffset, nextRow - this.rowsOffset);
                if (color != null) {
                    colors[ci] = (float)color.getRed() / 255.0f;
                    colors[ci + 1] = (float)color.getGreen() / 255.0f;
                    colors[ci + 2] = (float)color.getBlue() / 255.0f;
                    color = (Color)style.getPaint(col - this.colsOffset, row - this.rowsOffset);
                    colors[ci + 3] = (float)color.getRed() / 255.0f;
                    colors[ci + 4] = (float)color.getGreen() / 255.0f;
                    colors[ci + 5] = (float)color.getBlue() / 255.0f;
                } else {
                    colors[ci] = (float)style.getRed(col - this.colsOffset, nextRow - this.rowsOffset) / 255.0f;
                    colors[ci + 1] = (float)style.getGreen(col - this.colsOffset, nextRow - this.rowsOffset) / 255.0f;
                    colors[ci + 2] = (float)style.getBlue(col - this.colsOffset, nextRow - this.rowsOffset) / 255.0f;
                    colors[ci + 3] = (float)style.getRed(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
                    colors[ci + 4] = (float)style.getGreen(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
                    colors[ci + 5] = (float)style.getBlue(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
                }
                ci += 6;
                ++col;
            }
            coordinates[ci] = this.cols;
            coordinates[ci + 1] = coordinates[ci - 5];
            coordinates[ci + 2] = coordinates[ci - 4];
            coordinates[ci + 3] = this.cols;
            coordinates[ci + 4] = coordinates[ci - 2];
            coordinates[ci + 5] = coordinates[ci - 1];
            colors[ci] = colors[ci - 6];
            colors[ci + 1] = colors[ci - 5];
            colors[ci + 2] = colors[ci - 4];
            colors[ci + 3] = colors[ci - 3];
            colors[ci + 4] = colors[ci - 2];
            colors[ci + 5] = colors[ci - 1];
            ci += 6;
            ++row;
        }
        row = this.rows - 1;
        int col = 0;
        while (col < this.cols) {
            float swY3;
            float nwY = swY3 = style.getY(col - this.colsOffset, row - this.rowsOffset);
            coordinates[ci] = col;
            coordinates[ci + 1] = nwY;
            coordinates[ci + 2] = -(row + 1);
            coordinates[ci + 3] = col;
            coordinates[ci + 4] = swY3;
            coordinates[ci + 5] = -row;
            color = (Color)style.getPaint(col - this.colsOffset, row - this.rowsOffset);
            if (color != null) {
                colors[ci] = (float)color.getRed() / 255.0f;
                colors[ci + 1] = (float)color.getGreen() / 255.0f;
                colors[ci + 2] = (float)color.getBlue() / 255.0f;
                color = (Color)style.getPaint(col - this.colsOffset, row - this.rowsOffset);
                colors[ci + 3] = (float)color.getRed() / 255.0f;
                colors[ci + 4] = (float)color.getGreen() / 255.0f;
                colors[ci + 5] = (float)color.getBlue() / 255.0f;
            } else {
                colors[ci] = (float)style.getRed(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
                colors[ci + 1] = (float)style.getGreen(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
                colors[ci + 2] = (float)style.getBlue(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
                colors[ci + 3] = (float)style.getRed(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
                colors[ci + 4] = (float)style.getGreen(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
                colors[ci + 5] = (float)style.getBlue(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
            }
            ci += 6;
            ++col;
        }
        col = this.cols - 1;
        float nwY = swY = style.getY(col - this.colsOffset, row - this.rowsOffset);
        coordinates[ci] = this.cols;
        coordinates[ci + 1] = nwY;
        coordinates[ci + 2] = -(row + 1);
        coordinates[ci + 3] = this.cols;
        coordinates[ci + 4] = swY;
        coordinates[ci + 5] = -row;
        color = (Color)style.getPaint(col - this.colsOffset, row - this.rowsOffset);
        if (color != null) {
            colors[ci] = (float)color.getRed() / 255.0f;
            colors[ci + 1] = (float)color.getGreen() / 255.0f;
            colors[ci + 2] = (float)color.getBlue() / 255.0f;
            color = (Color)style.getPaint(col - this.colsOffset, row - this.rowsOffset);
            colors[ci + 3] = (float)color.getRed() / 255.0f;
            colors[ci + 4] = (float)color.getGreen() / 255.0f;
            colors[ci + 5] = (float)color.getBlue() / 255.0f;
        } else {
            colors[ci] = (float)style.getRed(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
            colors[ci + 1] = (float)style.getGreen(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
            colors[ci + 2] = (float)style.getBlue(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
            colors[ci + 3] = (float)style.getRed(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
            colors[ci + 4] = (float)style.getGreen(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
            colors[ci + 5] = (float)style.getBlue(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
        }
        int[] stripCounts = new int[this.rows];
        int strips = (this.cols + 1) * 2;
        int strip = 0;
        while (strip < this.rows) {
            stripCounts[strip] = strips;
            ++strip;
        }
        TriangleStripArray tsa = new TriangleStripArray(numCoords / 3, 133, stripCounts);
        tsa.setCoordRefFloat(coordinates);
        tsa.setColorRefFloat(colors);
        GeometryInfo gi = new GeometryInfo((GeometryArray)tsa);
        NormalGenerator gen = new NormalGenerator();
        gen.generateNormals(gi);
        this.geometry = gi.getGeometryArray(true, false, false);
        this.geometry.setCapability(21);
        this.geometry.setCapability(19);
        this.geometry.setCapability(8);
        this.geometry.setCapability(4);
        this.geometry.setCapability(5);
        return this.geometry;
    }

    @Override
    public synchronized void update(ValueLayerStyle3D style) {
        float nwY;
        Color color;
        this.applyNeeded = true;
        int i = 0;
        int row = 0;
        int n = this.rows - 1;
        while (row < n) {
            float swY;
            float nwY2;
            int nextRow;
            int col = 0;
            while (col < this.cols) {
                nextRow = row + 1;
                nwY2 = style.getY(col - this.colsOffset, nextRow - this.rowsOffset);
                swY = style.getY(col - this.colsOffset, row - this.rowsOffset);
                color = (Color)style.getPaint(col - this.colsOffset, nextRow - this.rowsOffset);
                if (color != null) {
                    this.updateArray[i++] = nwY2;
                    this.updateArray[i++] = (float)color.getRed() / 255.0f;
                    this.updateArray[i++] = (float)color.getGreen() / 255.0f;
                    this.updateArray[i++] = (float)color.getBlue() / 255.0f;
                    color = (Color)style.getPaint(col - this.colsOffset, row - this.rowsOffset);
                    this.updateArray[i++] = swY;
                    this.updateArray[i++] = (float)color.getRed() / 255.0f;
                    this.updateArray[i++] = (float)color.getGreen() / 255.0f;
                    this.updateArray[i++] = (float)color.getBlue() / 255.0f;
                } else {
                    this.updateArray[i++] = nwY2;
                    this.updateArray[i++] = (float)style.getRed(col - this.colsOffset, nextRow - this.rowsOffset) / 255.0f;
                    this.updateArray[i++] = (float)style.getGreen(col - this.colsOffset, nextRow - this.rowsOffset) / 255.0f;
                    this.updateArray[i++] = (float)style.getBlue(col - this.colsOffset, nextRow - this.rowsOffset) / 255.0f;
                    this.updateArray[i++] = swY;
                    this.updateArray[i++] = (float)style.getRed(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
                    this.updateArray[i++] = (float)style.getGreen(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
                    this.updateArray[i++] = (float)style.getBlue(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
                }
                ++col;
            }
            col = this.cols - 1;
            nextRow = row + 1;
            nwY2 = style.getY(col - this.colsOffset, nextRow - this.rowsOffset);
            swY = style.getY(col - this.colsOffset, row - this.rowsOffset);
            color = (Color)style.getPaint(col - this.colsOffset, nextRow - this.rowsOffset);
            if (color != null) {
                this.updateArray[i++] = nwY2;
                this.updateArray[i++] = (float)color.getRed() / 255.0f;
                this.updateArray[i++] = (float)color.getGreen() / 255.0f;
                this.updateArray[i++] = (float)color.getBlue() / 255.0f;
                color = (Color)style.getPaint(col - this.colsOffset, row - this.rowsOffset);
                this.updateArray[i++] = swY;
                this.updateArray[i++] = (float)color.getRed() / 255.0f;
                this.updateArray[i++] = (float)color.getGreen() / 255.0f;
                this.updateArray[i++] = (float)color.getBlue() / 255.0f;
            } else {
                this.updateArray[i++] = nwY2;
                this.updateArray[i++] = (float)style.getRed(col - this.colsOffset, nextRow - this.rowsOffset) / 255.0f;
                this.updateArray[i++] = (float)style.getGreen(col - this.colsOffset, nextRow - this.rowsOffset) / 255.0f;
                this.updateArray[i++] = (float)style.getBlue(col - this.colsOffset, nextRow - this.rowsOffset) / 255.0f;
                this.updateArray[i++] = swY;
                this.updateArray[i++] = (float)style.getRed(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
                this.updateArray[i++] = (float)style.getGreen(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
                this.updateArray[i++] = (float)style.getBlue(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
            }
            ++row;
        }
        row = this.rows - 1;
        int col = 0;
        while (col < this.cols) {
            float nwY3;
            float swY = nwY3 = style.getY(col - this.colsOffset, row - this.rowsOffset);
            color = (Color)style.getPaint(col - this.colsOffset, row - this.rowsOffset);
            if (color != null) {
                this.updateArray[i++] = nwY3;
                this.updateArray[i++] = (float)color.getRed() / 255.0f;
                this.updateArray[i++] = (float)color.getGreen() / 255.0f;
                this.updateArray[i++] = (float)color.getBlue() / 255.0f;
                color = (Color)style.getPaint(col - this.colsOffset, row - this.rowsOffset);
                this.updateArray[i++] = swY;
                this.updateArray[i++] = (float)color.getRed() / 255.0f;
                this.updateArray[i++] = (float)color.getGreen() / 255.0f;
                this.updateArray[i++] = (float)color.getBlue() / 255.0f;
            } else {
                this.updateArray[i++] = nwY3;
                this.updateArray[i++] = (float)style.getRed(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
                this.updateArray[i++] = (float)style.getGreen(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
                this.updateArray[i++] = (float)style.getBlue(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
                this.updateArray[i++] = swY;
                this.updateArray[i++] = (float)style.getRed(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
                this.updateArray[i++] = (float)style.getGreen(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
                this.updateArray[i++] = (float)style.getBlue(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
            }
            ++col;
        }
        col = this.cols - 1;
        float swY = nwY = style.getY(col - this.colsOffset, row - this.rowsOffset);
        color = (Color)style.getPaint(col - this.colsOffset, row - this.rowsOffset);
        if (color != null) {
            this.updateArray[i++] = nwY;
            this.updateArray[i++] = (float)color.getRed() / 255.0f;
            this.updateArray[i++] = (float)color.getGreen() / 255.0f;
            this.updateArray[i++] = (float)color.getBlue() / 255.0f;
            color = (Color)style.getPaint(col - this.colsOffset, row - this.rowsOffset);
            this.updateArray[i++] = swY;
            this.updateArray[i++] = (float)color.getRed() / 255.0f;
            this.updateArray[i++] = (float)color.getGreen() / 255.0f;
            this.updateArray[i++] = (float)color.getBlue() / 255.0f;
        } else {
            this.updateArray[i++] = nwY;
            this.updateArray[i++] = (float)style.getRed(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
            this.updateArray[i++] = (float)style.getGreen(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
            this.updateArray[i++] = (float)style.getBlue(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
            this.updateArray[i++] = swY;
            this.updateArray[i++] = (float)style.getRed(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
            this.updateArray[i++] = (float)style.getGreen(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
            this.updateArray[i++] = (float)style.getBlue(col - this.colsOffset, row - this.rowsOffset) / 255.0f;
        }
    }

    @Override
    public synchronized void applyUpdate(Geometry geometry) {
        if (this.applyNeeded) {
            GeometryArray array = (GeometryArray)geometry;
            float[] coordinates = array.getCoordRefFloat();
            float[] colors = array.getColorRefFloat();
            int i = 0;
            int ci = 0;
            while (i < this.updateArray.length) {
                coordinates[ci + 1] = this.updateArray[i++];
                colors[ci] = this.updateArray[i++];
                colors[ci + 1] = this.updateArray[i++];
                colors[ci + 2] = this.updateArray[i++];
                coordinates[ci + 4] = this.updateArray[i++];
                colors[ci + 3] = this.updateArray[i++];
                colors[ci + 4] = this.updateArray[i++];
                colors[ci + 5] = this.updateArray[i++];
                ci += 6;
            }
        }
        this.applyNeeded = false;
    }
}

