/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.visualization3D;

import com.sun.j3d.exp.swing.JCanvas3D;
import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import com.sun.j3d.utils.behaviors.mouse.MouseWheelZoom;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import com.sun.j3d.utils.pickfast.PickCanvas;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.Window;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Background;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.PickInfo;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import repast.simphony.space.graph.Network;
import repast.simphony.space.projection.Projection;
import repast.simphony.space.projection.ProjectionListener;
import repast.simphony.visualization.DisplayData;
import repast.simphony.visualization.DisplayEditorLifecycle;
import repast.simphony.visualization.IDisplayLayer;
import repast.simphony.visualization.Layout;
import repast.simphony.visualization.decorator.ProjectionDecorator3D;
import repast.simphony.visualization.editor.EditorFactory;
import repast.simphony.visualization.network.NetworkDisplayLayer3D;
import repast.simphony.visualization.visualization3D.AbstractDisplay3D;
import repast.simphony.visualization.visualization3D.AbstractDisplayLayer3D;
import repast.simphony.visualization.visualization3D.DefaultValueDisplayLayer3D;
import repast.simphony.visualization.visualization3D.DisplayLayer3D;
import repast.simphony.visualization.visualization3D.IDisplayLayer3D;
import repast.simphony.visualization.visualization3D.ValueDisplayLayer3D;
import repast.simphony.visualization.visualization3D.VisualItem3D;
import repast.simphony.visualization.visualization3D.style.DefaultEdgeStyle3D;
import repast.simphony.visualization.visualization3D.style.DefaultStyle3D;
import repast.simphony.visualization.visualization3D.style.EdgeStyle3D;
import repast.simphony.visualization.visualization3D.style.Style3D;
import repast.simphony.visualization.visualization3D.style.ValueLayerStyle3D;

public class Display3D
extends AbstractDisplay3D {
    public static final int TRANSFORMS_APPLIED = 1;
    private Style3D defaultStyle = new DefaultStyle3D();
    private EdgeStyle3D defaultEdgeStyle = new DefaultEdgeStyle3D();
    private boolean firstRender = true;
    private Color backgroundColor = null;
    private PickCanvas pick;
    private JCanvas3D canvas;
    private BranchGroup sceneRoot;
    private SimpleUniverse universe;
    private MainBehavior updater;
    private TransformGroup topRotTransGroup;
    private TransformGroup projectionTransGroup;
    private TransformGroup valueLayerTransGroup;
    private boolean updatedLastRender = false;

    static {
        SimpleUniverse.setJ3DThreadPriority((int)1);
    }

    public Display3D(DisplayData<?> data, Layout layout) {
        super(data, layout);
        this.initScene();
    }

    private void initScene() {
        this.sceneRoot = new BranchGroup();
        this.sceneRoot.setCapability(17);
        this.topRotTransGroup = new TransformGroup();
        this.topRotTransGroup.setCapability(18);
        this.topRotTransGroup.setCapability(17);
        this.topRotTransGroup.setCapability(13);
        this.sceneRoot.addChild((Node)this.topRotTransGroup);
        this.projectionTransGroup = new TransformGroup();
        this.projectionTransGroup.setCapability(18);
        this.projectionTransGroup.setCapability(17);
        this.projectionTransGroup.setCapability(13);
        this.projectionTransGroup.setCapability(12);
        this.projectionTransGroup.setCapability(14);
        this.topRotTransGroup.addChild((Node)this.projectionTransGroup);
        this.valueLayerTransGroup = new TransformGroup();
        this.valueLayerTransGroup.setCapability(18);
        this.valueLayerTransGroup.setCapability(17);
        this.valueLayerTransGroup.setCapability(13);
        this.valueLayerTransGroup.setCapability(12);
        this.valueLayerTransGroup.setCapability(14);
        this.topRotTransGroup.addChild((Node)this.valueLayerTransGroup);
        boolean tilt = false;
        if (!tilt) {
            boolean bl = tilt = !(this.valueLayer instanceof AbstractDisplay3D.DummyValueDisplayLayer);
        }
        if (tilt) {
            Transform3D trans = new Transform3D();
            trans.rotX(Math.toRadians(25.0));
            this.topRotTransGroup.setTransform(trans);
        }
    }

    private void initFirstRender() {
        Window window = SwingUtilities.getWindowAncestor(this.panel);
        GraphicsDevice device = window.getGraphicsConfiguration().getDevice();
        GraphicsConfigTemplate3D template = new GraphicsConfigTemplate3D();
        this.canvas = new JCanvas3D(template, device);
        this.canvas.setResizeMode(0);
        this.canvas.setPreferredSize(new Dimension(100, 100));
        this.canvas.setSize(this.canvas.getPreferredSize());
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){});
        this.panel.add((Component)this.canvas, "Center");
        this.universe = new SimpleUniverse(this.canvas.getOffscreenCanvas3D());
        this.universe.getViewingPlatform().setNominalViewingTransform();
        if (this.backgroundColor != null) {
            float r = (float)this.backgroundColor.getRed() / 255.0f;
            float g = (float)this.backgroundColor.getGreen() / 255.0f;
            float b = (float)this.backgroundColor.getBlue() / 255.0f;
            Background background = new Background(r, g, b);
            BoundingSphere sphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000000.0);
            background.setApplicationBounds((Bounds)sphere);
            this.sceneRoot.addChild((Node)background);
        }
        View view = this.canvas.getOffscreenCanvas3D().getView();
        view.setBackClipDistance(3000.0);
        view.setFrontClipDistance(0.01);
        this.panel.add((Component)this.canvas, "Center");
        this.initAdditional();
        this.sceneRoot.compile();
        this.universe.getLocale().addBranchGraph(this.sceneRoot);
        this.setPause(true);
    }

    private void initAdditional() {
        BoundingSphere bounds = new BoundingSphere(new Point3d(), 2.147483647E9);
        MouseRotate myMouseRotate = new MouseRotate((Component)this.canvas);
        myMouseRotate.setTransformGroup(this.topRotTransGroup);
        myMouseRotate.setSchedulingBounds((Bounds)bounds);
        myMouseRotate.setFactor(0.01);
        this.sceneRoot.addChild((Node)myMouseRotate);
        TransformGroup vpTrans = this.universe.getViewingPlatform().getViewPlatformTransform();
        MouseTranslate myMouseTranslate = new MouseTranslate((Component)this.canvas, 2);
        myMouseTranslate.setTransformGroup(vpTrans);
        myMouseTranslate.setSchedulingBounds((Bounds)bounds);
        this.sceneRoot.addChild((Node)myMouseTranslate);
        MouseZoom myMouseZoom = new MouseZoom((Component)this.canvas);
        myMouseZoom.setTransformGroup(vpTrans);
        myMouseZoom.setSchedulingBounds((Bounds)bounds);
        this.sceneRoot.addChild((Node)myMouseZoom);
        MouseWheelZoom myMouseWheelZoom = new MouseWheelZoom((Component)this.canvas);
        myMouseWheelZoom.setTransformGroup(vpTrans);
        myMouseWheelZoom.setSchedulingBounds((Bounds)bounds);
        this.sceneRoot.addChild((Node)myMouseWheelZoom);
        this.pick = new PickCanvas(this.canvas.getOffscreenCanvas3D(), this.sceneRoot);
        this.pick.setMode(2);
        this.pick.setFlags(10);
        this.pick.setTolerance(4.0f);
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                int clicks = event.getClickCount();
                if (clicks == 2 && SwingUtilities.isLeftMouseButton(event)) {
                    Display3D.this.picked(event);
                }
            }
        });
        DirectionalLight light = new DirectionalLight();
        light.setDirection(-1.0f, -1.0f, -2.0f);
        light.setInfluencingBounds((Bounds)bounds);
        this.sceneRoot.addChild((Node)light);
        AmbientLight ambient = new AmbientLight();
        ambient.setInfluencingBounds((Bounds)bounds);
        this.sceneRoot.addChild((Node)ambient);
        this.updater = new MainBehavior();
        this.updater.setSchedulingBounds((Bounds)bounds);
        this.sceneRoot.addChild((Node)this.updater);
    }

    private void picked(MouseEvent evt) {
        Shape3D shape;
        this.pick.setShapeLocation(evt);
        PickInfo pickResult = this.pick.pickClosest();
        if (pickResult != null && (shape = (Shape3D)pickResult.getNode()) != null) {
            this.probe(shape, pickResult.getClosestIntersectionPoint());
        }
    }

    @Override
    public void init() {
        super.init();
        if (this.valueLayer == null) {
            this.valueLayer = new AbstractDisplay3D.DummyValueDisplayLayer();
        } else if (this.valueLayer instanceof DefaultValueDisplayLayer3D) {
            ((DefaultValueDisplayLayer3D)this.valueLayer).registerGrid((Group)this.projectionTransGroup);
        }
        this.valueLayer.init(this.updater);
        for (Projection proj : this.initData.getProjections()) {
            ProjectionDecorator3D decorator = (ProjectionDecorator3D)this.decoratorMap.get(proj.getName());
            if (decorator == null) continue;
            decorator.init(this, (Group)this.projectionTransGroup);
        }
        this.update();
        this.valueLayer.applyUpdates();
        for (IDisplayLayer display : this.displayMap.values()) {
            display.applyUpdates();
        }
        for (IDisplayLayer display : this.networkMap.values()) {
            display.applyUpdates();
        }
        for (ProjectionDecorator3D deco : this.decoratorMap.values()) {
            deco.update();
        }
        BoundingSphere bounds = (BoundingSphere)this.projectionTransGroup.getBounds();
        Point3d center = new Point3d();
        bounds.getCenter(center);
        center.negate();
        Transform3D trans = new Transform3D();
        trans.set(new Vector3d((Tuple3d)center));
        this.projectionTransGroup.setTransform(trans);
    }

    @Override
    public JCanvas3D getCanvas() {
        return this.canvas;
    }

    public BranchGroup getSceneRoot() {
        return this.sceneRoot;
    }

    public void probe(Shape3D shape, Point3d intersectPoint) {
        IDisplayLayer3D layer3D;
        Object obj = null;
        for (IDisplayLayer<VisualItem3D> layer : this.displayMap.values()) {
            layer3D = layer;
            obj = layer3D.findObjsForItem(shape);
            if (obj != null) break;
        }
        if (obj == null) {
            for (IDisplayLayer<VisualItem3D> layer : this.networkMap.values()) {
                layer3D = (NetworkDisplayLayer3D)layer;
                obj = ((AbstractDisplayLayer3D)layer3D).findObjsForItem(shape);
                if (obj != null) break;
            }
        }
        if (obj == null && this.valueLayer instanceof DefaultValueDisplayLayer3D) {
            obj = ((DefaultValueDisplayLayer3D)this.valueLayer).findObjForShape(shape, intersectPoint);
        }
        if (obj != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(obj);
            this.probeSupport.fireProbeEvent((Object)this, list);
        }
    }

    public VisualItem3D getVisualObject(Object obj) {
        AbstractDisplayLayer3D layer = this.findLayer(obj);
        return (VisualItem3D)layer.getVisualItem(obj);
    }

    @Override
    protected AbstractDisplayLayer3D createDisplayLayer(Style3D style) {
        if (style == null) {
            return new DisplayLayer3D(this.defaultStyle, (Group)this.projectionTransGroup);
        }
        return new DisplayLayer3D(style, (Group)this.projectionTransGroup);
    }

    @Override
    public AbstractDisplayLayer3D createEdgeLayer(EdgeStyle3D style, Network network) {
        NetworkDisplayLayer3D layer = style == null ? new NetworkDisplayLayer3D(network, this.defaultEdgeStyle, (Group)this.projectionTransGroup, this) : new NetworkDisplayLayer3D(network, style, (Group)this.projectionTransGroup, this);
        layer.setNetworkDirected(network.isDirected());
        return layer;
    }

    @Override
    public ValueDisplayLayer3D createValueLayerDisplayLayer(ValueLayerStyle3D style) {
        return new DefaultValueDisplayLayer3D(style, (Group)this.valueLayerTransGroup, this);
    }

    public JPanel getPanel() {
        if (this.panel == null) {
            this.createPanel();
            this.panel.setLayout(new BorderLayout());
        }
        return this.panel;
    }

    public synchronized void render() {
        if (this.firstRender) {
            this.initFirstRender();
            this.updater.setTriggered(true);
            this.lastRenderTS = System.currentTimeMillis();
            this.firstRender = false;
        } else if (this.iconified || !this.canvas.isShowing()) {
            this.updatedLastRender = false;
        } else {
            long ts = System.currentTimeMillis();
            if (ts - this.lastRenderTS > FRAME_UPDATE_INTERVAL) {
                this.updater.setTriggered(true);
                this.lastRenderTS = ts;
            }
        }
    }

    public void setPause(boolean pause) {
        if (!this.updatedLastRender && pause) {
            this.updater.setPaused(true);
            this.updater.setTriggered(true);
        } else {
            this.updater.setPaused(false);
            this.updater.setEnable(!pause);
        }
    }

    public void closed() {
    }

    public void iconified() {
        this.iconified = true;
    }

    public void deIconified() {
        this.iconified = false;
    }

    @Override
    public void destroy() {
        super.destroy();
        for (Projection proj : this.initData.getProjections()) {
            proj.removeProjectionListener((ProjectionListener)this);
        }
        this.initData = null;
        Window window = SwingUtilities.getWindowAncestor(this.panel);
        if (window != null) {
            window.removeWindowListener(this);
        }
        this.canvas.getOffscreenCanvas3D().stopRenderer();
        this.panel.remove((Component)this.canvas);
        HierarchyListener[] hierarchyListenerArray = this.panel.getHierarchyListeners();
        int n = hierarchyListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            HierarchyListener listener = hierarchyListenerArray[n2];
            this.panel.removeHierarchyListener(listener);
            ++n2;
        }
        this.panel = null;
        this.universe.getLocale().removeBranchGraph(this.sceneRoot);
        this.universe.removeAllLocales();
        this.universe.cleanup();
        EditorFactory.getInstance().reset();
        this.probeSupport = null;
        this.dlSupport = null;
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
        super.windowDeiconified(e);
        this.panel.remove((Component)this.canvas);
        this.panel.add((Component)this.canvas, "Center");
    }

    public Layout getLayout() {
        return this.layout;
    }

    public DisplayEditorLifecycle createEditor(JPanel panel) {
        return EditorFactory.getInstance().create3DEditor(this, panel);
    }

    public void resetHomeView() {
        Transform3D trans = new Transform3D();
        trans.rotX(Math.toRadians(25.0));
        this.topRotTransGroup.setTransform(trans);
        this.universe.getViewingPlatform().setNominalViewingTransform();
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void toggleInfoProbe() {
    }

    class MainBehavior
    extends Behavior {
        private boolean triggered = false;
        private boolean paused = false;
        private WakeupCondition wakeup = new WakeupOnElapsedFrames(0);

        public boolean isTriggered() {
            return this.triggered;
        }

        public void setTriggered(boolean triggered) {
            this.triggered = triggered;
        }

        public void setPaused(boolean val) {
            this.paused = val;
        }

        public void initialize() {
            this.wakeupOn(this.wakeup);
        }

        public void processStimulus(Enumeration criteria) {
            if (this.triggered) {
                for (IDisplayLayer display : Display3D.this.displayMap.values()) {
                    display.applyUpdates();
                }
                for (IDisplayLayer display : Display3D.this.networkMap.values()) {
                    display.applyUpdates();
                }
                for (ProjectionDecorator3D deco : Display3D.this.decoratorMap.values()) {
                    deco.update();
                }
                Display3D.this.valueLayer.applyUpdates();
                this.postId(1);
                this.triggered = false;
                if (this.paused) {
                    this.paused = false;
                    this.setEnable(false);
                }
            }
            this.wakeupOn(this.wakeup);
        }
    }
}

