/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.visualization3D;

import java.awt.Color;
import java.awt.Font;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import repast.simphony.visualization.visualization3D.Label;
import repast.simphony.visualization.visualization3D.style.Style3D;

public abstract class AbstractLabel
implements Label {
    private static final float SCALE = 3800.0f;
    protected String label;
    protected Style3D.LabelPosition position;
    protected BranchGroup group;
    protected boolean updated = true;
    protected Color3f color = new Color3f(Color.YELLOW);
    protected Font3D font = new Font3D(new Font("Helvetica", 0, 10), new FontExtrusion());
    protected Appearance appearance = new Appearance();
    protected float textScale = (float)this.font.getFont().getSize() / 3800.0f;
    protected float offset = 0.0f;
    protected float textWidth;
    private Point3d textUpper = new Point3d();

    public AbstractLabel() {
        this("", Style3D.LabelPosition.NORTH);
    }

    public AbstractLabel(String label, Style3D.LabelPosition position) {
        this.label = label;
        this.position = position;
        this.group = new BranchGroup();
        this.group.setCapability(17);
        this.group.setCapability(14);
        this.group.setCapability(13);
        this.group.setPickable(false);
        this.appearance.setCapability(8);
        this.appearance.setColoringAttributes(new ColoringAttributes(this.color, 3));
        this.appearance.getColoringAttributes().setCapability(1);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        if (this.label == null && label != null || this.label != null && label == null || this.label != null) {
            this.label = label;
            this.updated = true;
        }
    }

    @Override
    public Style3D.LabelPosition getPosition() {
        return this.position;
    }

    @Override
    public void setColor(Color color) {
        if (color != null && !color.equals(this.color.get())) {
            this.color.set(color);
            this.appearance.getColoringAttributes().setColor(this.color);
        }
    }

    @Override
    public Color getColor() {
        return this.color.get();
    }

    @Override
    public void setFont(Font font) {
        if (font != null && !this.font.getFont().equals(font)) {
            this.font = new Font3D(font, new FontExtrusion());
            this.textScale = (float)font.getSize() / 3800.0f;
            this.updated = true;
        }
    }

    @Override
    public Font getFont() {
        return this.font.getFont();
    }

    @Override
    public float getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(float offset) {
        if (this.offset != offset) {
            this.offset = offset;
            this.updated = true;
        }
    }

    @Override
    public void setPosition(Style3D.LabelPosition position) {
        if (this.position != position) {
            this.position = position;
            this.updated = true;
        }
    }

    protected abstract Vector3f getTranslation(Point3f var1, float var2);

    @Override
    public BranchGroup getBranchGroup(Point3f center, Group object) {
        if (this.updated) {
            Bounds bounds;
            this.group.detach();
            this.group.removeAllChildren();
            this.updated = false;
            if (this.label == null || this.label.trim().length() == 0) {
                return this.group;
            }
            float radius = this.offset;
            if (this.offset == 0.0f && (bounds = object.getBounds()) instanceof BoundingSphere) {
                radius = (float)((BoundingSphere)bounds).getRadius();
            }
            Text3D text = new Text3D(this.font, this.label);
            BoundingBox box = new BoundingBox();
            text.getBoundingBox(box);
            box.getUpper(this.textUpper);
            this.textUpper.scale((double)this.textScale);
            this.textWidth = (float)this.textUpper.x;
            OrientedShape3D shape3D = new OrientedShape3D((Geometry)text, this.appearance, 0, new Vector3f(0.0f, 1.0f, 0.0f));
            Transform3D transform = new Transform3D();
            transform.set(this.getTranslation(center, radius));
            transform.setScale((double)this.textScale);
            TransformGroup tGroup = new TransformGroup(transform);
            tGroup.addChild((Node)shape3D);
            BranchGroup tmp = new BranchGroup();
            tmp.addChild((Node)tGroup);
            tmp.setCapability(17);
            this.group.addChild((Node)tmp);
            this.group.compile();
            return this.group;
        }
        return null;
    }
}

