/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.visualization3D;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import repast.simphony.visualization.Layout;
import repast.simphony.visualization.LayoutUpdater;
import repast.simphony.visualization.visualization3D.IDisplayLayer3D;
import repast.simphony.visualization.visualization3D.Label;
import repast.simphony.visualization.visualization3D.VisualItem3D;
import repast.simphony.visualization.visualization3D.VisualItem3DAdderRemover;
import repast.simphony.visualization.visualization3D.style.Style3D;

public abstract class AbstractDisplayLayer3D
implements IDisplayLayer3D {
    protected Style3D style;
    protected BranchGroup parentGroup;
    protected Set<Object> objsToAdd = new HashSet<Object>();
    protected Set<Object> objsToRemove = new HashSet<Object>();
    protected VisualItem3DAdderRemover adder = new VisualItem3DAdderRemover();
    protected final Map<Object, VisualItem3D> visualItemMap = new HashMap<Object, VisualItem3D>();

    public AbstractDisplayLayer3D(Style3D style, Group topGroup) {
        this.style = style;
        this.parentGroup = new BranchGroup();
        this.parentGroup.setCapability(14);
        this.parentGroup.setCapability(13);
        topGroup.addChild((Node)this.parentGroup);
    }

    @Override
    public void addObject(Object obj) {
        this.objsToAdd.add(obj);
        this.objsToRemove.remove(obj);
    }

    @Override
    public void removeObject(Object obj) {
        if (!this.objsToAdd.remove(obj)) {
            this.objsToRemove.add(obj);
        }
    }

    protected abstract void createItemsForAddedObjects(Layout var1, boolean var2);

    protected void removeItemsForRemovedObjects() {
        for (Object obj : this.objsToRemove) {
            VisualItem3D item = this.visualItemMap.remove(obj);
            this.adder.addItemForRemoval(item);
        }
        this.objsToRemove.clear();
    }

    @Override
    public VisualItem3D getVisualItem(Object obj) {
        return this.visualItemMap.get(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object findObjsForItem(Shape3D shape) {
        Map<Object, VisualItem3D> map = this.visualItemMap;
        synchronized (map) {
            for (VisualItem3D item : this.visualItemMap.values()) {
                Iterator<Shape3D> iter = item.shapes();
                while (iter.hasNext()) {
                    Shape3D itemShape = iter.next();
                    if (!itemShape.equals(shape)) continue;
                    return item.getVisualizedObject();
                }
            }
        }
        return null;
    }

    protected abstract void doUpdate(Layout var1, boolean var2);

    protected abstract Label createLabel();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(LayoutUpdater updater) {
        Map<Object, VisualItem3D> map = this.visualItemMap;
        synchronized (map) {
            this.createItemsForAddedObjects(updater.getLayout(), updater.getDoSetLocationForAdded());
            this.removeItemsForRemovedObjects();
            this.doUpdate(updater.getLayout(), updater.getUpdateItemsLocation());
        }
    }

    public void setStyle(Style3D style) {
        this.style = style;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyUpdates() {
        Map<Object, VisualItem3D> map = this.visualItemMap;
        synchronized (map) {
            this.adder.execute(this.parentGroup);
            for (VisualItem3D item : this.visualItemMap.values()) {
                item.applyTransform();
            }
        }
    }
}

