/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.visualization2D.layout;

import edu.uci.ics.jung.algorithms.layout.TreeLayout;
import edu.uci.ics.jung.graph.DelegateTree;
import edu.uci.ics.jung.graph.Forest;
import repast.simphony.space.graph.Network;
import repast.simphony.space.graph.RepastEdge;
import repast.simphony.visualization.AbstractNetworkLayout;
import repast.simphony.visualization.Box;
import repast.simphony.visualization.visualization2D.Display2D;

public class TreeLayout2D<T>
extends AbstractNetworkLayout<T> {
    protected TreeLayout<T, RepastEdge<T>> layout;
    protected Network<T> network;

    @Override
    public void setProjection(Network<T> projection) {
        this.baseGraph = projection;
        this.network = this.baseGraph;
        this.setLayout();
    }

    @Override
    public void update() {
        if (this.network != null) {
            this.setProjection(this.network);
        }
    }

    protected void setLayout() {
        if (!this.network.isDirected() || this.network.numEdges() < 1) {
            return;
        }
        DelegateTree tree = new DelegateTree();
        for (Object t : this.network.getNodes()) {
            if (this.network.getDegree(t) == 0) continue;
            if (!this.network.getPredecessors(t).iterator().hasNext()) {
                tree.setRoot(t);
            }
            for (Object child : this.network.getSuccessors(t)) {
                tree.addChild((Object)this.network.getEdge(t, child), t, child);
            }
        }
        this.layout = new TreeLayout((Forest)tree);
    }

    public float[] getLocation(T obj) {
        float[] location = new float[]{0.0f, 0.0f};
        if (this.layout == null) {
            location[0] = (float)Display2D.DISPLAY_WIDTH / 2.0f;
            location[1] = (float)Display2D.DISPLAY_HEIGHT / 2.0f;
        } else {
            location[0] = (float)this.layout.transform(obj).getX();
            location[1] = (float)(-this.layout.transform(obj).getY());
        }
        return location;
    }

    public Box getBoundingBox() {
        return new Box();
    }
}

