/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.visualization2D;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import org.piccolo2d.PLayer;
import org.piccolo2d.PNode;
import org.piccolo2d.nodes.PImage;
import repast.simphony.valueLayer.ValueLayer;
import repast.simphony.visualization.visualization2D.RepastCanvas2D;
import repast.simphony.visualization.visualization2D.style.ValueLayerStyle;

public class ValueDisplayLayer2D
extends PLayer {
    private ValueLayerStyle style;
    private PImage node;
    private int xDim;
    private int yDim;
    private int xOffset;
    private int yOffset;
    private int[] data;

    public void addDataLayer(ValueLayer layer) {
        int[] dims = layer.getDimensions().toIntArray(null);
        int[] origin = layer.getDimensions().originToIntArray(null);
        if (dims.length > 3 || dims.length == 3 && dims[2] != 0) {
            throw new IllegalArgumentException("Data Layers with more than 2 dimensions are unsupported");
        }
        this.xDim = Math.max(dims[0], this.xDim);
        this.yDim = Math.max(dims[1], this.yDim);
        this.xOffset = origin[0];
        this.yOffset = origin[1];
    }

    public ValueDisplayLayer2D(ValueLayerStyle style, RepastCanvas2D canvas) {
        super.setPickable(true);
        this.style = style;
        canvas.addLayer(this);
    }

    public void setStyle(ValueLayerStyle style) {
        this.style = style;
    }

    public void init(ValueLayer layer) {
        this.addDataLayer(layer);
        float cellSize = this.style.getCellSize();
        BufferedImage bimage = new BufferedImage(this.xDim, this.yDim, 2);
        Graphics2D g2d = bimage.createGraphics();
        g2d.setColor(Color.WHITE);
        g2d.fill(new Rectangle2D.Float(0.0f, 0.0f, (float)this.xDim * cellSize, (float)this.yDim * cellSize));
        g2d.dispose();
        this.node = new PImage((Image)bimage);
        this.node.setBounds((Rectangle2D)new Rectangle2D.Float(0.0f, 0.0f, (float)this.xDim * cellSize, (float)this.yDim * cellSize));
        this.node.translate((double)(-cellSize / 2.0f), (double)(-cellSize / 2.0f));
        this.data = ((DataBufferInt)bimage.getRaster().getDataBuffer()).getData();
        this.addChild((PNode)this.node);
    }

    public void applyUpdates() {
        int i = 0;
        int y = -this.yOffset;
        while (y < this.yDim - this.yOffset) {
            int x = -this.xOffset;
            while (x < this.xDim - this.xOffset) {
                Color color = (Color)this.style.getPaint(x, y);
                if (color != null) {
                    this.data[i] = color.getRGB();
                } else {
                    int a = -16777216;
                    int r = this.style.getRed(x, y) << 16;
                    int b = this.style.getGreen(x, y) << 8;
                    int g = this.style.getBlue(x, y);
                    this.data[i] = a + r + g + b;
                }
                ++i;
                ++x;
            }
            ++y;
        }
        this.repaint();
    }

    public PImage getNode() {
        return this.node;
    }

    public ValueLayerStyle getStyle() {
        return this.style;
    }

    public int[] convertPixelToLoc(Point2D point) {
        int[] loc = new int[2];
        float cellSize = this.style.getCellSize();
        double offSet = cellSize / 2.0f;
        loc[0] = (int)Math.floor((point.getX() + offSet) / (double)cellSize) - this.xOffset;
        loc[1] = (int)Math.floor((point.getY() + offSet) / (double)cellSize) - this.yOffset;
        return loc;
    }
}

