/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.visualization2D;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Paint;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.piccolo2d.PCamera;
import org.piccolo2d.PNode;
import org.piccolo2d.event.PBasicInputEventHandler;
import org.piccolo2d.event.PInputEvent;
import org.piccolo2d.event.PInputEventListener;
import org.piccolo2d.nodes.PPath;
import org.piccolo2d.util.PPickPath;
import org.piccolo2d.util.PStack;
import repast.simphony.space.graph.Network;
import repast.simphony.space.projection.Projection;
import repast.simphony.space.projection.ProjectionListener;
import repast.simphony.ui.RSGUIConstants;
import repast.simphony.ui.probe.ProbeManager;
import repast.simphony.valueLayer.ValueLayer;
import repast.simphony.visualization.AbstractDisplay;
import repast.simphony.visualization.AddedRemovedLayoutUpdater;
import repast.simphony.visualization.DisplayData;
import repast.simphony.visualization.DisplayEditorLifecycle;
import repast.simphony.visualization.IDisplay;
import repast.simphony.visualization.IDisplayLayer;
import repast.simphony.visualization.IntervalLayoutUpdater;
import repast.simphony.visualization.Layout;
import repast.simphony.visualization.LayoutUpdater;
import repast.simphony.visualization.MovedLayoutUpdater;
import repast.simphony.visualization.UpdateLayoutUpdater;
import repast.simphony.visualization.decorator.ProjectionDecorator2D;
import repast.simphony.visualization.editor.EditorFactory;
import repast.simphony.visualization.engine.BoundingBox;
import repast.simphony.visualization.network.NetworkDisplayLayer2D;
import repast.simphony.visualization.visualization2D.DisplayLayer2D;
import repast.simphony.visualization.visualization2D.IDisplayLayer2D;
import repast.simphony.visualization.visualization2D.RepastCanvas2D;
import repast.simphony.visualization.visualization2D.StyledDisplayLayer2D;
import repast.simphony.visualization.visualization2D.ValueDisplayLayer2D;
import repast.simphony.visualization.visualization2D.style.EdgeStyle2D;
import repast.simphony.visualization.visualization2D.style.Style2D;
import repast.simphony.visualization.visualization2D.style.ValueLayerStyle;
import simphony.util.ThreadUtilities;

public class Display2D
extends AbstractDisplay
implements WindowListener {
    public static int DISPLAY_HEIGHT = 500;
    public static int DISPLAY_WIDTH = 500;
    protected final Object lock = new Object();
    protected Map<Class, IDisplayLayer2D> classStyleMap;
    protected Map<Object, IDisplayLayer2D> objectStyleMap;
    protected ValueDisplayLayer2D valueDisplayLayer;
    protected Layout layout;
    protected LayoutUpdater layoutUpdater;
    protected DisplayData<?> initData;
    protected boolean iconified = false;
    protected JPanel panel;
    private boolean addWindowListener = true;
    protected Runnable renderer;
    protected Updater updater;
    protected RepastCanvas2D canvas;
    protected Map<String, ProjectionDecorator2D> decoratorMap;
    protected Iterable<ValueLayer> valueLayers;
    protected boolean doRender = true;
    protected boolean showHoverProbes = false;
    protected PPath hoverProbe = new PPath.Double();
    protected PPath hoverProbeBox;
    protected Object lastProbedObject = null;
    protected boolean pause = true;

    public Display2D(DisplayData<?> data, Layout layout) {
        this.classStyleMap = new LinkedHashMap<Class, IDisplayLayer2D>();
        this.objectStyleMap = new HashMap<Object, IDisplayLayer2D>();
        this.initData = data;
        this.layout = layout;
        this.valueLayers = data.getValueLayers();
        this.layoutUpdater = new UpdateLayoutUpdater(layout);
        this.canvas = new RepastCanvas2D();
        this.decoratorMap = new HashMap<String, ProjectionDecorator2D>();
        this.hoverProbe.setPickable(false);
        this.canvas.getCamera().addChild((PNode)this.hoverProbe);
        this.initHoverProbeBox();
        this.initScene();
    }

    public DisplayData getInitData() {
        return this.initData;
    }

    protected void initScene() {
        PBasicInputEventHandler listener = new PBasicInputEventHandler(){
            private List<Object> probedObjects;

            public void mouseClicked(PInputEvent event) {
                if (event.isLeftMouseButton() && event.getClickCount() == 2) {
                    PPickPath path = event.getPath();
                    Point2D probeLocation = event.getPosition();
                    this.probedObjects = Display2D.this.getprobedObjects(path, probeLocation);
                    if (this.probedObjects.size() > 0) {
                        Display2D.this.probeSupport.fireProbeEvent((Object)this, this.probedObjects);
                    }
                }
            }

            public void mouseMoved(PInputEvent event) {
                if (Display2D.this.showHoverProbes && Display2D.this.pause) {
                    PPickPath path = event.getInputManager().getMouseOver();
                    Point2D probeLocation = event.getPosition();
                    this.probedObjects = Display2D.this.getprobedObjects(path, probeLocation);
                    Object obj = null;
                    if (this.probedObjects.size() > 0) {
                        obj = this.probedObjects.get(0);
                    }
                    Display2D.this.showHoverProbe(event, obj);
                }
            }
        };
        this.canvas.addInputEventListener((PInputEventListener)listener);
    }

    private void initHoverProbeBox() {
        Color color = new Color(155, 177, 228);
        int width = 250;
        int height = 200;
        int titleHeight = 17;
        this.hoverProbeBox = PPath.createRectangle((float)0.0f, (float)0.0f, (float)width, (float)height);
        this.hoverProbeBox.setPaint((Paint)color);
        this.hoverProbeBox.setTransparency(0.75f);
        this.hoverProbeBox.setStroke(null);
        PPath titleRect = PPath.createRectangle((float)0.0f, (float)0.0f, (float)width, (float)titleHeight);
        titleRect.setPaint((Paint)color);
        titleRect.setStroke(null);
        this.hoverProbeBox.addChild((PNode)titleRect);
    }

    private void showHoverProbe(PInputEvent event, Object obj) {
        Point2D p = event.getCanvasPosition();
        event.getPath().canvasToLocal(p, (PNode)this.canvas.getCamera());
        int horzProbeOffset = 20;
        int vertProbeOffset = 0;
        if (obj == null || obj == this.lastProbedObject) {
            if (obj == this.lastProbedObject) {
                if (p.getY() > (double)(DISPLAY_HEIGHT / 2)) {
                    vertProbeOffset = -((int)this.hoverProbeBox.getHeight());
                }
                this.hoverProbe.setOffset(p.getX() + (double)horzProbeOffset, p.getY() + (double)vertProbeOffset);
            } else {
                this.hoverProbe.removeAllChildren();
                this.lastProbedObject = null;
            }
        }
    }

    private String trimString(String string, int length) {
        if (string.length() > length) {
            return string.substring(0, length);
        }
        return string;
    }

    private String getNamesForHoverProbe(Object obj, Map<String, Object> valuesMap) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(this.trimString(ProbeManager.createTitle((Object)obj), 30)) + "\n");
        for (String name : valuesMap.keySet()) {
            buffer.append(String.valueOf(this.trimString(name, 15)) + "\n");
        }
        return buffer.toString();
    }

    private String getValuesForHoverProbe(Map<String, Object> valuesMap) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n");
        for (String name : valuesMap.keySet()) {
            Object val = valuesMap.get(name);
            buffer.append(String.valueOf(this.trimString(val.toString(), 15)) + "\n");
        }
        return buffer.toString();
    }

    public Object findObjForItem(PNode node) {
        ArrayList<PNode> nodes = new ArrayList<PNode>();
        nodes.add(node);
        Collection<IDisplayLayer2D> layers = this.classStyleMap.values();
        for (IDisplayLayer2D layer : layers) {
            Collection<Object> objs = layer.findObjsForItems(nodes);
            if (objs.size() <= 0) continue;
            return objs.iterator().next();
        }
        Collection<IDisplayLayer2D> netLayers = this.objectStyleMap.values();
        for (IDisplayLayer2D layer : netLayers) {
            Collection<Object> objs = layer.findObjsForItems(nodes);
            if (objs.size() <= 0) continue;
            return objs.iterator().next();
        }
        return null;
    }

    protected List<Object> getprobedObjects(PPickPath path, Point2D probeLocation) {
        PStack pNodes = path.getNodeStackReference();
        Iterator iter = pNodes.iterator();
        while (iter.hasNext()) {
            PNode node = (PNode)iter.next();
            if (!(node instanceof PCamera) && !(node instanceof DisplayLayer2D)) continue;
            iter.remove();
        }
        int numToFind = pNodes.size();
        ArrayList<Object> probedObjects = new ArrayList<Object>();
        if (pNodes.contains((Object)this.valueDisplayLayer)) {
            int[] loc = this.valueDisplayLayer.convertPixelToLoc(probeLocation);
            ValueLayer vl = this.valueLayers.iterator().next();
            Object dLoc = new double[loc.length];
            int i22 = 0;
            while (i22 < loc.length) {
                dLoc[i22] = (double)loc[i22];
                ++i22;
            }
            double i22 = vl.get((double[])dLoc);
        }
        Collection<IDisplayLayer2D> layers = this.classStyleMap.values();
        for (IDisplayLayer2D layer : layers) {
            Collection<Object> objs = layer.findObjsForItems((Collection<PNode>)pNodes);
            probedObjects.addAll(objs);
            if (probedObjects.size() == numToFind) break;
            for (Object obj : objs) {
                pNodes.remove(layer.getVisualItem(obj));
            }
        }
        if (pNodes.size() != 0) {
            Collection<IDisplayLayer2D> netLayers = this.objectStyleMap.values();
            for (IDisplayLayer2D layer : netLayers) {
                Collection<Object> objs = layer.findObjsForItems((Collection<PNode>)pNodes);
                probedObjects.addAll(objs);
                if (probedObjects.size() == numToFind) break;
                for (Object obj : objs) {
                    pNodes.remove(layer.getVisualItem(obj));
                }
            }
        }
        return probedObjects;
    }

    public void registerDecorator(ProjectionDecorator2D decorator) {
        this.decoratorMap.put(decorator.getProjection().getName(), decorator);
    }

    public void init() {
        for (Object obj : this.initData.objects()) {
            this.addObject(obj);
        }
        for (ValueLayer layer : this.initData.getValueLayers()) {
            this.valueDisplayLayer.init(layer);
        }
        ValueDisplayLayer2D baseLayer = this.valueDisplayLayer != null ? this.valueDisplayLayer : this.canvas.getLayer();
        for (Projection proj : this.initData.getProjections()) {
            proj.addProjectionListener((ProjectionListener)this);
        }
        this.renderer = new Renderer();
        this.updater = new Updater();
        this.update();
        this.forceRender();
    }

    public void setBoundingBox(BoundingBox box) {
        Rectangle2D rect = box.getRectangle();
        this.canvas.getCamera().animateViewToCenterBounds(rect, true, 0L);
    }

    public void registerStyle(Class clazz, Style2D style) {
        IDisplayLayer2D layer = this.classStyleMap.get(clazz);
        if (layer == null) {
            layer = new StyledDisplayLayer2D(style, this.canvas);
            this.classStyleMap.put(clazz, layer);
        } else {
            ((StyledDisplayLayer2D)layer).setStyle(style);
        }
    }

    public void registerNetworkStyle(Network topology, EdgeStyle2D style) {
        IDisplayLayer2D layer = this.objectStyleMap.get(topology);
        if (layer == null) {
            layer = new NetworkDisplayLayer2D(topology, style, this, this.canvas);
            this.objectStyleMap.put(topology, layer);
        } else {
            ((NetworkDisplayLayer2D)layer).setStyle(style);
        }
    }

    public void registerValueLayerStyle(ValueLayerStyle style) {
        if (this.valueDisplayLayer == null) {
            this.valueDisplayLayer = new ValueDisplayLayer2D(style, this.canvas);
        } else {
            this.valueDisplayLayer.setStyle(style);
        }
    }

    public void createPanel() {
        this.panel = new JPanel();
        this.panel.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (e.getChangeFlags() == 2L && Display2D.this.addWindowListener) {
                    Window window = SwingUtilities.getWindowAncestor(Display2D.this.panel);
                    window.addWindowListener(Display2D.this);
                    Display2D.this.addWindowListener = false;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render() {
        if (this.doRender && this.canvas.isShowing()) {
            Object object = this.lock;
            synchronized (object) {
                ThreadUtilities.runInEventThread((Runnable)this.renderer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceRender() {
        Object object = this.lock;
        synchronized (object) {
            ThreadUtilities.runInEventThread((Runnable)this.renderer);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        for (Projection proj : this.initData.getProjections()) {
            proj.removeProjectionListener((ProjectionListener)this);
        }
        this.initData = null;
        Window window = SwingUtilities.getWindowAncestor(this.panel);
        if (window != null) {
            window.removeWindowListener(this);
        }
        EditorFactory.getInstance().reset();
    }

    public JPanel getPanel() {
        if (this.panel == null) {
            this.createPanel();
            JScrollPane scroller = new JScrollPane((Component)((Object)this.canvas));
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)scroller, "Center");
        }
        return this.panel;
    }

    @Override
    protected void addObject(Object o) {
        IDisplayLayer2D layer = this.findLayer(o);
        if (layer != null) {
            layer.addObject(o);
            this.layoutUpdater.addTriggerCondition(LayoutUpdater.Condition.ADDED);
        }
    }

    @Override
    protected void moveObject(Object o) {
        this.layoutUpdater.addTriggerCondition(LayoutUpdater.Condition.MOVED);
    }

    protected IDisplayLayer2D findLayer(Object obj) {
        Class<?> objClass = obj.getClass();
        IDisplayLayer2D layer = this.classStyleMap.get(objClass);
        if (layer == null) {
            for (Class clazz : this.classStyleMap.keySet()) {
                if (!clazz.isAssignableFrom(objClass)) continue;
                layer = this.classStyleMap.get(clazz);
                break;
            }
        }
        return layer;
    }

    @Override
    protected void removeObject(Object o) {
        IDisplayLayer2D layer = this.findLayer(o);
        if (layer != null) {
            layer.removeObject(o);
            this.layoutUpdater.addTriggerCondition(LayoutUpdater.Condition.REMOVED);
        }
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
        this.layoutUpdater.setLayout(layout);
    }

    public void setLayoutFrequency(IDisplay.LayoutFrequency frequency, int interval) {
        if (frequency == IDisplay.LayoutFrequency.AT_UPDATE) {
            this.layoutUpdater = new UpdateLayoutUpdater(this.layout);
        } else if (frequency == IDisplay.LayoutFrequency.AT_INTERVAL) {
            this.layoutUpdater = new IntervalLayoutUpdater(this.layout, interval);
        } else if (frequency == IDisplay.LayoutFrequency.ON_NEW) {
            this.layoutUpdater = new AddedRemovedLayoutUpdater(this.layout);
        } else if (frequency == IDisplay.LayoutFrequency.ON_MOVE) {
            this.layoutUpdater = new MovedLayoutUpdater(this.layout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Object object = this.lock;
        synchronized (object) {
            this.layoutUpdater.update();
            this.doRender = true;
            ThreadUtilities.runInEventThread((Runnable)this.updater);
        }
    }

    public PNode getVisualItem(Object o) {
        IDisplayLayer2D layer = this.findLayer(o);
        PNode pNode = null;
        if (layer != null) {
            pNode = (PNode)layer.getVisualItem(o);
        }
        if (pNode == null) {
            for (IDisplayLayer2D netLayer : this.objectStyleMap.values()) {
                pNode = (PNode)netLayer.getVisualItem(o);
                if (pNode != null) break;
            }
        }
        return pNode;
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
        this.iconified = false;
    }

    @Override
    public void windowIconified(WindowEvent e) {
        this.iconified = true;
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    public void setPause(boolean pause) {
        this.pause = pause;
        if (pause) {
            this.forceRender();
        }
    }

    public void iconified() {
    }

    public void closed() {
    }

    public void deIconified() {
    }

    public Layout getLayout() {
        return this.layout;
    }

    public List<Class> getRegisteredClasses() {
        return new ArrayList<Class>(this.classStyleMap.keySet());
    }

    public DisplayEditorLifecycle createEditor(JPanel panel) {
        return EditorFactory.getInstance().create2DEditor(this, this.canvas, panel);
    }

    public void resetHomeView() {
        this.canvas.resetHomeView();
    }

    public void setBackgroundColor(Color color) {
        if (color != null) {
            this.canvas.setBackground(color);
        }
    }

    @Override
    public void registerToolBar(JToolBar bar) {
        JToggleButton infoButton = new JToggleButton();
        infoButton.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Display2D.this.toggleInfoProbe();
            }
        });
        infoButton.setText(null);
        infoButton.setIcon(RSGUIConstants.VIZ_INFO_ICON);
        infoButton.setToolTipText("Toggle Info Probe");
        bar.add(infoButton);
    }

    public void toggleInfoProbe() {
        if (!this.showHoverProbes) {
            this.showHoverProbes = true;
            this.canvas.setCursor(INFO_CURSOR);
        } else {
            this.showHoverProbes = false;
            this.canvas.setCursor(new Cursor(0));
        }
    }

    class Renderer
    implements Runnable {
        Renderer() {
        }

        @Override
        public void run() {
            for (IDisplayLayer iDisplayLayer : Display2D.this.classStyleMap.values()) {
                iDisplayLayer.applyUpdates();
            }
            for (IDisplayLayer iDisplayLayer : Display2D.this.objectStyleMap.values()) {
                iDisplayLayer.applyUpdates();
            }
            for (ProjectionDecorator2D projectionDecorator2D : Display2D.this.decoratorMap.values()) {
                projectionDecorator2D.update();
            }
            if (Display2D.this.valueDisplayLayer != null) {
                Display2D.this.valueDisplayLayer.applyUpdates();
            }
            Display2D.this.doRender = false;
        }
    }

    class Updater
    implements Runnable {
        Updater() {
        }

        @Override
        public void run() {
            for (IDisplayLayer iDisplayLayer : Display2D.this.classStyleMap.values()) {
                iDisplayLayer.update(Display2D.this.layoutUpdater);
            }
            for (IDisplayLayer iDisplayLayer : Display2D.this.objectStyleMap.values()) {
                iDisplayLayer.update(Display2D.this.layoutUpdater);
            }
        }
    }
}

