/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.network;

import java.util.Iterator;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.vecmath.Point3f;
import repast.simphony.space.graph.Network;
import repast.simphony.space.graph.RepastEdge;
import repast.simphony.space.projection.ProjectionEvent;
import repast.simphony.space.projection.ProjectionListener;
import repast.simphony.visualization.Layout;
import repast.simphony.visualization.network.DirectedEdgeVisualItem;
import repast.simphony.visualization.network.DirectedLineEdgeVisualItem;
import repast.simphony.visualization.network.EdgeLabel;
import repast.simphony.visualization.network.EdgeVisualItem;
import repast.simphony.visualization.network.LineEdgeVisualItem3D;
import repast.simphony.visualization.visualization3D.AbstractDisplayLayer3D;
import repast.simphony.visualization.visualization3D.Display3D;
import repast.simphony.visualization.visualization3D.Label;
import repast.simphony.visualization.visualization3D.ShapeFactory;
import repast.simphony.visualization.visualization3D.VisualItem3D;
import repast.simphony.visualization.visualization3D.style.DefaultEdgeStyle3D;
import repast.simphony.visualization.visualization3D.style.EdgeStyle3D;
import repast.simphony.visualization.visualization3D.style.TaggedAppearance;
import repast.simphony.visualization.visualization3D.style.TaggedBranchGroup;

public class NetworkDisplayLayer3D
extends AbstractDisplayLayer3D
implements ProjectionListener {
    private Display3D display;
    private EdgeStyle3D edgeStyle;
    private boolean isDirected = false;

    public NetworkDisplayLayer3D(Network<?> net, EdgeStyle3D style, Group topGroup, Display3D display) {
        super(style, topGroup);
        this.edgeStyle = style;
        this.display = display;
        if (style == null) {
            this.style = new DefaultEdgeStyle3D();
        }
        net.addProjectionListener((ProjectionListener)this);
        for (RepastEdge edge : net.getEdges()) {
            this.objsToAdd.add(edge);
        }
    }

    public EdgeStyle3D getEdgeStyle() {
        return this.edgeStyle;
    }

    @Override
    protected void createItemsForAddedObjects(Layout layout, boolean doLayout) {
        for (Object obj : this.objsToAdd) {
            VisualItem3D item = this.createVisualItem(obj);
            this.visualItemMap.put(obj, item);
            this.adder.addItemForAddition(item);
        }
        this.objsToAdd.clear();
    }

    protected VisualItem3D createVisualItem(Object obj) {
        EdgeVisualItem item;
        if (this.edgeStyle.getEdgeType() == EdgeStyle3D.EdgeType.LINE) {
            TaggedBranchGroup rep = new TaggedBranchGroup("_LINE_EDGE_");
            BranchGroup group = rep.getBranchGroup();
            Shape3D shape = ShapeFactory.createLine(1.0f, "_LINE_EDGE_");
            group.addChild((Node)shape);
            item = this.isDirected ? new DirectedLineEdgeVisualItem(rep, obj, this.createLabel(), this.edgeStyle) : new LineEdgeVisualItem3D(rep, obj, this.createLabel());
            TaggedAppearance attrib = this.style.getAppearance(obj, null, shape.getUserData());
            item.setShapeAppearance(shape, attrib);
        } else {
            TaggedBranchGroup rep = this.style.getBranchGroup(obj, null);
            item = this.isDirected ? new DirectedEdgeVisualItem(rep, obj, this.createLabel(), this.edgeStyle) : new EdgeVisualItem(rep, obj, this.createLabel());
            Iterator<Shape3D> iter = item.shapes();
            while (iter.hasNext()) {
                Shape3D shape = iter.next();
                TaggedAppearance attrib = this.style.getAppearance(obj, null, shape.getUserData());
                item.setShapeAppearance(shape, attrib);
            }
        }
        return item;
    }

    @Override
    protected Label createLabel() {
        return new EdgeLabel();
    }

    @Override
    public void doUpdate(Layout layout, boolean layoutPerformed) {
        for (VisualItem3D item : this.visualItemMap.values()) {
            RepastEdge edge = (RepastEdge)item.getVisualizedObject();
            item.updateTaggedBranchGroup(this.edgeStyle);
            item.updateAppearance(this.edgeStyle);
            item.updateLabel(this.edgeStyle);
            item.updateScale(this.style);
            VisualItem3D source = this.display.getVisualObject(edge.getSource());
            VisualItem3D target = this.display.getVisualObject(edge.getTarget());
            if (!source.hasMoved() && !target.hasMoved() && !this.adder.isNew(item)) continue;
            Point3f pt1 = source.getLocation();
            Point3f pt2 = target.getLocation();
            float scale = 1.0f;
            scale = source.getScale() != null ? source.getScale()[0] : 1.0f;
            float sourceRadius = scale * (float)((BoundingSphere)source.getTaggedBranchGroup().getBranchGroup().getBounds()).getRadius();
            scale = target.getScale() != null ? target.getScale()[0] : 1.0f;
            float targetRadius = scale * (float)((BoundingSphere)target.getTaggedBranchGroup().getBranchGroup().getBounds()).getRadius();
            item.updateLocation(pt1, sourceRadius, pt2, targetRadius);
        }
    }

    public void setNetworkDirected(boolean directed) {
        this.isDirected = directed;
    }

    public void projectionEventOccurred(ProjectionEvent evt) {
        if (evt.getType() == ProjectionEvent.EDGE_ADDED) {
            this.addObject((RepastEdge)evt.getSubject());
        } else if (evt.getType() == ProjectionEvent.EDGE_REMOVED) {
            this.removeObject((RepastEdge)evt.getSubject());
        }
    }
}

