/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.network;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import repast.simphony.visualization.visualization3D.Label;
import repast.simphony.visualization.visualization3D.VisualItem3D;
import repast.simphony.visualization.visualization3D.style.Style3D;
import repast.simphony.visualization.visualization3D.style.TaggedBranchGroup;

public class EdgeVisualItem
extends VisualItem3D {
    private static final Vector3f init = new Vector3f(0.0f, 1.0f, 0.0f);
    protected AxisAngle4f rotation = new AxisAngle4f();
    protected float height;
    Vector3f axis = new Vector3f();
    Vector3f needed = new Vector3f();
    Point3f midpoint;
    Point3f Ps = new Point3f();
    Point3f Pt = new Point3f();

    public EdgeVisualItem(TaggedBranchGroup tGroup, Object o, Label label) {
        super(tGroup, o, label);
    }

    protected void doUpdateLocation(Point3f source, Point3f target) {
        this.setScale(1.0f, this.height, 1.0f);
        this.needed.sub((Tuple3f)target, (Tuple3f)source);
        float angle = this.needed.angle(init);
        this.axis.cross(init, this.needed);
        this.rotation.set(this.axis.x, this.axis.y, this.axis.z, angle);
        this.setRotation(this.rotation);
    }

    private Point3f findLineSphereIntersect(Point3f P1, Point3f P2, float r) {
        float[] dc = new float[3];
        float[] p1 = new float[3];
        float[] p2 = new float[3];
        p1[0] = P1.x;
        p1[1] = P1.y;
        p1[2] = P1.z;
        p2[0] = P2.x;
        p2[1] = P2.y;
        p2[2] = P2.z;
        dc[0] = p2[0] - p1[0];
        dc[1] = p2[1] - p1[1];
        dc[2] = p2[2] - p1[2];
        float dcm = dc[0];
        int dcmi = 0;
        if (Math.abs(dc[0]) < Math.abs(dc[1])) {
            dcm = dc[1];
            dcmi = 1;
        }
        if (Math.abs(dc[2]) > Math.abs(dcm)) {
            dcm = dc[2];
            dcmi = 2;
        }
        float A = 1.0f;
        int i = 0;
        while (i <= 2) {
            if (i != dcmi) {
                A += dc[i] / dcm * (dc[i] / dcm);
            }
            ++i;
        }
        float a = 1.0f;
        float b = -2.0f * p1[dcmi];
        float c = p1[dcmi] * p1[dcmi] - r * r / A;
        float disc = b * b - 4.0f * a * c;
        float[] pplus = new float[3];
        float[] pminus = new float[3];
        pminus[dcmi] = (-b - (float)Math.sqrt(disc)) / 2.0f;
        pplus[dcmi] = (-b + (float)Math.sqrt(disc)) / 2.0f;
        int i2 = 0;
        while (i2 <= 2) {
            if (i2 != dcmi) {
                pminus[i2] = dc[i2] / dcm * (pminus[dcmi] - p1[dcmi]) + p1[i2];
                pplus[i2] = dc[i2] / dcm * (pplus[dcmi] - p1[dcmi]) + p1[i2];
            }
            ++i2;
        }
        Point3f Pplus = new Point3f(pplus[0], pplus[1], pplus[2]);
        Point3f Pminus = new Point3f(pminus[0], pminus[1], pminus[2]);
        if (P2.distance(Pplus) < P2.distance(Pminus)) {
            return Pplus;
        }
        return Pminus;
    }

    protected void calculateEndPoints(Point3f source, float sourceRadius, Point3f target, float targetRadius) {
        this.midpoint = new Point3f();
        Point3f sum = new Point3f();
        if (source.distance(target) > sourceRadius + targetRadius) {
            this.Ps = this.findLineSphereIntersect(source, target, sourceRadius);
            this.Pt = this.findLineSphereIntersect(target, source, targetRadius);
            this.height = this.Ps.distance(this.Pt);
            sum.add((Tuple3f)this.Ps, (Tuple3f)this.Pt);
        } else {
            this.height = 0.0f;
            sum.add((Tuple3f)target, (Tuple3f)source);
        }
        this.midpoint.scale(0.5f, (Tuple3f)sum);
        this.setLocation(this.midpoint);
    }

    @Override
    public void updateLocation(Point3f source, float sourceRadius, Point3f target, float targetRadius) {
        this.calculateEndPoints(source, sourceRadius, target, targetRadius);
        this.doUpdateLocation(source, target);
    }

    @Override
    public void updateScale(Style3D style) {
        float[] point = style.getScale(this.visualizedObject);
        if (point != null) {
            this.setScale(point[0], this.height, point[2]);
        }
    }
}

