/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.gui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.pietschy.wizard.InvalidStateException;
import org.pietschy.wizard.WizardModel;
import repast.simphony.ui.plugin.editor.PluginWizardStep;
import repast.simphony.visualization.engine.CartesianDisplayDescriptor;
import repast.simphony.visualization.engine.DisplayDescriptor;
import repast.simphony.visualization.engine.ValueLayerDescriptor;
import repast.simphony.visualization.gui.DisplayWizardModel;
import repast.simphony.visualization.gui.StyleClassFinder;
import repast.simphony.visualization.gui.styleBuilder.EditedValueLayerStyleDialog;

public class ValueLayerStep
extends PluginWizardStep {
    private static final long serialVersionUID = -60523735303617830L;
    private static final String EDIT_ICON = "edit.png";
    private DisplayWizardModel model;
    private JList objList;
    private DefaultComboBoxModel styleModel;
    private JComboBox styleBox;
    private JButton buildStyleButton;
    private String editedStyleName;

    public ValueLayerStep() {
        super("Value Layer Details", "Please provide a style for the value layers below. These value layers will be passed to the selected style.");
    }

    protected JPanel getContentPanel() {
        this.objList = new JList(new DefaultListModel());
        this.styleModel = new DefaultComboBoxModel();
        this.buildStyleButton = new JButton();
        FormLayout layout = new FormLayout("50, 3dlu, 50, 3dlu, 50, pref:grow", "6dlu, pref, 3dlu, pref, 3dlu, pref, pref:grow");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        JTextField classFld = new JTextField();
        classFld.setEditable(false);
        this.styleBox = new JComboBox(this.styleModel);
        this.styleBox.setEditable(true);
        CellConstraints cc = new CellConstraints();
        builder.add((Component)new JScrollPane(this.objList), cc.xywh(1, 1, 3, 7));
        builder.addLabel("Value Layer Style Class Name:", cc.xyw(5, 2, 2));
        builder.add((Component)this.styleBox, cc.xyw(5, 4, 2));
        builder.add((Component)this.buildStyleButton, cc.xy(5, 6));
        this.buildStyleButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource(EDIT_ICON)));
        this.buildStyleButton.setToolTipText("Edit the style of the selected agent type");
        this.buildStyleButton.addActionListener(new editBtnListener());
        this.styleBox.setEditable(true);
        this.styleBox.setPrototypeDisplayValue("repast.simphony.visualization.visualization3D.style.DefaultStyle3D");
        this.objList.setPrototypeCellValue("SimpleHappyAgent");
        return builder.getPanel();
    }

    public void init(WizardModel wizardModel) {
        this.model = (DisplayWizardModel)wizardModel;
    }

    public void applyState() throws InvalidStateException {
        DisplayDescriptor descriptor = this.model.getDescriptor();
        ((ValueLayerDescriptor)((Object)descriptor)).setValueLayerStyleName(this.styleBox.getSelectedItem().toString());
        ((ValueLayerDescriptor)((Object)descriptor)).setValueLayerEditedStyleName(this.editedStyleName);
    }

    public void prepare() {
        List<String> vals;
        DisplayDescriptor descriptor = this.model.getDescriptor();
        List<String> style2DCache = null;
        List<String> style3DCache = null;
        if (descriptor.getDisplayType().equals("3D")) {
            if (style3DCache == null) {
                style3DCache = StyleClassFinder.getAvailable3DValueLayerStyles(this.model.getContext());
            }
            vals = style3DCache;
        } else {
            if (style2DCache == null) {
                style2DCache = StyleClassFinder.getAvailable2DValueLayerStyles(this.model.getContext());
            }
            vals = style2DCache;
        }
        String styleName = ((ValueLayerDescriptor)((Object)descriptor)).getValueLayerStyleName();
        if (styleName != null && !vals.contains(styleName)) {
            vals.add(styleName);
        }
        Collections.sort(vals);
        this.styleModel.removeAllElements();
        for (String val : vals) {
            this.styleModel.addElement(val);
        }
        if (styleName != null) {
            this.styleBox.setSelectedItem(styleName);
        }
        DefaultListModel listModel = (DefaultListModel)this.objList.getModel();
        listModel.removeAllElements();
        for (String name : ((ValueLayerDescriptor)((Object)descriptor)).getValueLayerNames()) {
            listModel.addElement(name);
        }
        this.setComplete(true);
    }

    class editBtnListener
    implements ActionListener {
        editBtnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            DisplayDescriptor descriptor = ValueLayerStep.this.model.getDescriptor();
            try {
                EditedValueLayerStyleDialog dialog = new EditedValueLayerStyleDialog((JDialog)SwingUtilities.getWindowAncestor((Component)((Object)ValueLayerStep.this)));
                ValueLayerStep.this.editedStyleName = ((ValueLayerDescriptor)((Object)descriptor)).getValueLayerEditedStyleName();
                String layerName = ((ValueLayerDescriptor)((Object)descriptor)).getValueLayerNames().iterator().next();
                dialog.init(layerName, ValueLayerStep.this.editedStyleName, (CartesianDisplayDescriptor)ValueLayerStep.this.model.getDescriptor());
                dialog.pack();
                dialog.setVisible(true);
                if (dialog.doSave()) {
                    String styleClassName = null;
                    if (ValueLayerStep.this.model.getDescriptor().getDisplayType().equals("2D")) {
                        styleClassName = "repast.simphony.visualization.editedStyle.EditedValueLayerStyle2D";
                    } else if (ValueLayerStep.this.model.getDescriptor().getDisplayType().equals("3D")) {
                        styleClassName = "repast.simphony.visualization.editedStyle.EditedValueLayerStyle3D";
                    }
                    if (ValueLayerStep.this.styleModel.getIndexOf(styleClassName) < 0) {
                        ValueLayerStep.this.styleModel.addElement(styleClassName);
                    }
                    ValueLayerStep.this.styleBox.setSelectedItem(styleClassName);
                    ValueLayerStep.this.editedStyleName = dialog.getUserStyleName();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

