/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.gui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import repast.simphony.ui.editor.ClassListItem;
import repast.simphony.util.collections.Pair;

public abstract class StyleTableModel
extends AbstractTableModel {
    protected String[] COLUMN_NAMES;
    private static final Class[] COLUMN_CLASSES = new Class[]{String.class, String.class};
    protected List<Pair<ClassListItem, ClassListItem>> items = new ArrayList<Pair<ClassListItem, ClassListItem>>();
    protected List<Pair<ClassListItem, ClassListItem>> oldItems = new ArrayList<Pair<ClassListItem, ClassListItem>>();

    public void addRow(ClassListItem className, ClassListItem styleName) {
        this.items.add((Pair<ClassListItem, ClassListItem>)new Pair((Object)className, (Object)styleName));
        this.fireTableRowsInserted(this.items.size() - 1, this.items.size() - 1);
    }

    @Override
    public String getColumnName(int column) {
        return this.COLUMN_NAMES[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_CLASSES[columnIndex];
    }

    @Override
    public int getRowCount() {
        return this.items.size();
    }

    @Override
    public int getColumnCount() {
        return this.COLUMN_NAMES.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Pair<ClassListItem, ClassListItem> pair = this.items.get(rowIndex);
        if (columnIndex == 0) {
            return pair.getFirst();
        }
        return pair.getSecond();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Pair<ClassListItem, ClassListItem> pair = this.items.get(rowIndex);
        if (aValue instanceof String) {
            aValue = new ClassListItem(aValue.toString());
        }
        if (columnIndex == 0) {
            pair.setFirst((Object)((ClassListItem)aValue));
        } else {
            pair.setSecond((Object)((ClassListItem)aValue));
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public void deleteRow(int row) {
        this.items.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public void swapItems() {
        List<Pair<ClassListItem, ClassListItem>> tmp = this.items;
        this.items = this.oldItems;
        this.oldItems = tmp;
        this.fireTableDataChanged();
    }
}

