/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.gui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.pietschy.wizard.InvalidStateException;
import org.pietschy.wizard.WizardModel;
import repast.simphony.ui.plugin.editor.PluginWizardStep;
import repast.simphony.visualization.engine.DisplayDescriptor;
import repast.simphony.visualization.gui.DisplayWizardModel;

public abstract class StyleStep
extends PluginWizardStep {
    private static final long serialVersionUID = 1179847211916347928L;
    public static final String UP_ICON = "agent_up.png";
    public static final String DOWN_ICON = "agent_down.png";
    public static final String EDIT_ICON = "edit.png";
    public static final String ADD_ICON = "edit_add.png";
    public static final String REMOVE_ICON = "edit_remove.png";
    protected DisplayWizardModel model;
    protected JList<AgentTypeElement> agentList;
    protected DefaultListModel<AgentTypeElement> agentListModel;
    protected boolean reordering = false;
    protected int currentIndex = -1;
    protected JTextField classFld;

    public StyleStep(String name, String description) {
        super(name, description);
    }

    protected JPanel getContentPanel() {
        FormLayout layout = new FormLayout("pref:grow, 6dlu, pref:grow", "pref, 4dlu, pref, 4dlu, pref, 4dlu, fill:pref:grow");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        this.agentListModel = new DefaultListModel();
        this.agentList = new JList<AgentTypeElement>(this.agentListModel);
        this.agentList.setToolTipText("This is the list of agents currently defined for this display");
        this.classFld = new JTextField();
        this.classFld.setEditable(false);
        this.classFld.setToolTipText("This is the class name for the selected agent");
        CellConstraints cc = new CellConstraints();
        builder.addSeparator("Agents", cc.xyw(1, 1, 1));
        builder.add((Component)new JScrollPane(this.agentList), cc.xywh(1, 3, 1, 5));
        this.agentList.setVisibleRowCount(14);
        builder.addLabel("Agent Class:", cc.xy(3, 3));
        builder.add((Component)this.classFld, cc.xy(3, 5));
        builder.add((Component)this.getStylePanel(), cc.xy(3, 7));
        this.agentList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && !StyleStep.this.reordering) {
                    StyleStep.this.setCurrentElementValues();
                    StyleStep.this.currentIndex = StyleStep.this.agentList.getSelectedIndex();
                    if (StyleStep.this.agentList.getSelectedValue() == null) {
                        StyleStep.this.classFld.setText("");
                    } else {
                        AgentTypeElement element = StyleStep.this.agentList.getSelectedValue();
                        StyleStep.this.classFld.setText(element.agentClassName);
                        StyleStep.this.agentListChanged(element);
                    }
                }
                StyleStep.this.reordering = false;
            }
        });
        return builder.getPanel();
    }

    protected abstract JPanel getStylePanel();

    protected abstract void setCurrentElementValues();

    protected abstract void agentListChanged(AgentTypeElement var1);

    protected abstract void applyChanges();

    protected abstract void initialize();

    public void init(WizardModel wizardModel) {
        this.model = (DisplayWizardModel)wizardModel;
    }

    public void applyState() throws InvalidStateException {
        this.applyChanges();
    }

    public void prepare() {
        this.currentIndex = -1;
        this.agentListModel.clear();
        DisplayDescriptor descriptor = this.model.getDescriptor();
        Map<String, Integer> layers = descriptor.getLayerOrders();
        ArrayList<String> tempList = new ArrayList<String>();
        HashMap<Integer, String> layerMapInv = new HashMap<Integer, String>();
        ArrayList<Integer> orders = new ArrayList<Integer>();
        for (String className : layers.keySet()) {
            layerMapInv.put(layers.get(className), className);
            orders.add(layers.get(className));
        }
        Collections.sort(orders);
        Iterator<String> iterator = orders.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)((Object)iterator.next());
            tempList.add(i, (String)layerMapInv.get(i));
        }
        Collections.reverse(tempList);
        for (String className : tempList) {
            String agentLabel = this.getShortName(className);
            this.agentListModel.addElement(new AgentTypeElement(agentLabel, className));
        }
        this.initialize();
        this.agentList.setSelectedIndex(0);
        this.setComplete(true);
    }

    private String getShortName(String className) {
        int index = className.lastIndexOf(".");
        if (index != -1 && index != className.length() - 1) {
            return className.substring(index + 1, className.length());
        }
        return null;
    }

    protected static class AgentTypeElement {
        private String agentName;
        private String agentClassName;
        private Map<String, Object> values = new HashMap<String, Object>();

        public AgentTypeElement(String agentName, String agentClassName) {
            this.agentName = agentName;
            this.agentClassName = agentClassName;
        }

        public String toString() {
            return this.agentName;
        }

        public Object getValue(String key) {
            return this.values.get(key);
        }

        public void setValue(String key, Object value) {
            this.values.put(key, value);
        }

        public String getAgentName() {
            return this.agentName;
        }

        public String getAgentClassName() {
            return this.agentClassName;
        }
    }
}

