/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.gui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import repast.simphony.ui.plugin.editor.SquareIcon;
import repast.simphony.visualization.engine.CartesianDisplayDescriptor;
import repast.simphony.visualization.engine.DisplayDescriptor;
import repast.simphony.visualization.engine.VisualizationRegistry;
import repast.simphony.visualization.engine.VisualizationRegistryData;
import repast.simphony.visualization.gui.StyleClassFinder;
import repast.simphony.visualization.gui.StyleStep;
import repast.simphony.visualization.gui.styleBuilder.EditedStyleDialog;
import repast.simphony.visualization.visualization3D.style.DefaultStyle3D;
import repast.simphony.visualization.visualization3D.style.Style3D;
import repast.simphony.visualizationOGL2D.DefaultStyleOGL2D;
import repast.simphony.visualizationOGL2D.StyleOGL2D;
import simphony.util.messages.MessageCenter;

public class StyleClassStep
extends StyleStep {
    private static final long serialVersionUID = -8619245538953523657L;
    private static final MessageCenter msg = MessageCenter.getMessageCenter(StyleClassStep.class);
    private static final String STYLE_KEY = "style class name";
    private static final String EDITED_STYLE_KEY = "edited style class name";
    protected DefaultComboBoxModel<String> styleModel;
    protected JButton buildStyleButton;
    protected JButton bgcolorBtn;
    protected JComboBox<String> styleBox;
    protected Map<String, String> editedStyleFileMap = new HashMap<String, String>();
    protected Color backgroundColor;
    protected static Map<Class<?>, List<String>> styleCache = new HashMap();

    public StyleClassStep() {
        super("Agent Style", "Please provide a style for each agent type in the model");
    }

    @Override
    protected JPanel getStylePanel() {
        FormLayout layout = new FormLayout("pref:grow, 4dlu, pref, 4dlu, pref, 4dlu, pref", "pref, 4dlu, pref, 4dlu, pref, 4dlu, pref, 4dlu, pref:grow");
        PanelBuilder builder = new PanelBuilder(layout);
        this.styleModel = new DefaultComboBoxModel();
        this.styleBox = new JComboBox<String>(this.styleModel);
        this.styleBox.setToolTipText("This is the style class for the selected agent. Select a style from this box or use the editor to create a new style");
        this.styleBox.setEditable(true);
        CellConstraints cc = new CellConstraints();
        builder.addLabel("Style Class:", cc.xyw(1, 1, 7));
        builder.add(this.styleBox, cc.xyw(1, 3, 5));
        this.buildStyleButton = new JButton();
        builder.add((Component)this.buildStyleButton, cc.xy(7, 3));
        this.buildStyleButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("edit.png")));
        this.buildStyleButton.setToolTipText("Edit the style of the selected agent type");
        this.buildStyleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    EditedStyleDialog dialog = new EditedStyleDialog((JDialog)SwingUtilities.getWindowAncestor((Component)((Object)StyleClassStep.this)));
                    String editedStyleName = StyleClassStep.this.model.getDescriptor().getEditedStyleName(StyleClassStep.this.classFld.getText());
                    dialog.init(Class.forName(StyleClassStep.this.classFld.getText()), editedStyleName, (CartesianDisplayDescriptor)StyleClassStep.this.model.getDescriptor());
                    dialog.pack();
                    dialog.setVisible(true);
                    if (dialog.doSave()) {
                        String styleClassName = null;
                        if (StyleClassStep.this.model.getDescriptor().getDisplayType().equals("2D")) {
                            styleClassName = "repast.simphony.visualization.editedStyle.EditedStyle2D";
                        } else if (StyleClassStep.this.model.getDescriptor().getDisplayType().equals("3D")) {
                            styleClassName = "repast.simphony.visualization.editedStyle.EditedStyle3D";
                        }
                        if (StyleClassStep.this.styleModel.getIndexOf(styleClassName) < 0) {
                            StyleClassStep.this.styleModel.addElement(styleClassName);
                        }
                        StyleClassStep.this.styleBox.setSelectedItem(styleClassName);
                        StyleClassStep.this.editedStyleFileMap.put(StyleClassStep.this.classFld.getText(), dialog.getUserStyleName());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        builder.addLabel("Display Background Color:", cc.xy(1, 5));
        this.bgcolorBtn = new JButton();
        builder.add((Component)this.bgcolorBtn, cc.xy(7, 5));
        this.bgcolorBtn.setToolTipText("Click to change background color");
        this.bgcolorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Color c = JColorChooser.showDialog((Component)((Object)StyleClassStep.this), "Select Display Background Color", StyleClassStep.this.backgroundColor);
                if (c != null) {
                    StyleClassStep.this.setBackgroundColor(c);
                }
            }
        });
        return builder.getPanel();
    }

    @Override
    protected void agentListChanged(StyleStep.AgentTypeElement element) {
        this.styleBox.setSelectedItem(element.getValue(STYLE_KEY));
    }

    @Override
    protected void setCurrentElementValues() {
        if (this.currentIndex != -1 && this.currentIndex < this.agentListModel.size()) {
            StyleStep.AgentTypeElement element = (StyleStep.AgentTypeElement)this.agentListModel.get(this.currentIndex);
            Object selectedItem = this.styleBox.getSelectedItem();
            if (selectedItem != null) {
                String styleClassName = selectedItem.toString();
                element.setValue(STYLE_KEY, styleClassName);
                if ("repast.simphony.visualization.editedStyle.EditedStyle2D".equals(styleClassName) || "repast.simphony.visualization.editedStyle.EditedStyle3D".equals(styleClassName) || "repast.simphony.visualization.editedStyle.EditedStyleGIS3D".equals(styleClassName)) {
                    element.setValue(EDITED_STYLE_KEY, this.editedStyleFileMap.get(element.getAgentClassName()));
                } else {
                    element.setValue(EDITED_STYLE_KEY, null);
                }
            }
        }
    }

    @Override
    public void applyChanges() {
        this.setCurrentElementValues();
        DisplayDescriptor descriptor = this.model.getDescriptor();
        descriptor.getStyles().clear();
        descriptor.getEditedStyles().clear();
        int i = 0;
        while (i < this.agentListModel.size()) {
            StyleStep.AgentTypeElement element = (StyleStep.AgentTypeElement)this.agentListModel.get(i);
            descriptor.addStyle(element.getAgentClassName(), (String)element.getValue(STYLE_KEY));
            descriptor.addEditedStyle(element.getAgentClassName(), (String)element.getValue(EDITED_STYLE_KEY));
            ++i;
        }
        descriptor.setBackgroundColor(this.backgroundColor);
    }

    @Override
    public void initialize() {
        this.editedStyleFileMap.clear();
        DisplayDescriptor descriptor = this.model.getDescriptor();
        String defaultStyle = this.getDefaultStyle(descriptor);
        if (this.model.getDescriptor() instanceof CartesianDisplayDescriptor) {
            this.buildStyleButton.setEnabled(true);
        } else {
            this.buildStyleButton.setEnabled(false);
        }
        List<Object> foundStyleClasses = new ArrayList();
        if (descriptor.getDisplayType().equals("3D")) {
            foundStyleClasses = this.findStylesFor(Style3D.class, defaultStyle);
        } else if (descriptor.getDisplayType().equals("2D")) {
            foundStyleClasses = this.findStylesFor(StyleOGL2D.class, defaultStyle);
        } else {
            Class<?> clazz = VisualizationRegistry.getDataFor(descriptor.getDisplayType()).getStyleInterface();
            if (clazz != null) {
                foundStyleClasses = this.findStylesFor(clazz, defaultStyle);
            } else {
                msg.warn((Object)("No style interface defined for" + descriptor.getDisplayType()), new Object[0]);
            }
        }
        Collections.sort(foundStyleClasses);
        this.styleModel.removeAllElements();
        for (String string : foundStyleClasses) {
            this.styleModel.addElement(string);
        }
        Enumeration enumeration = this.agentListModel.elements();
        while (enumeration.hasMoreElements()) {
            StyleStep.AgentTypeElement e = (StyleStep.AgentTypeElement)enumeration.nextElement();
            String className = e.getAgentClassName();
            String style = descriptor.getStyleClassName(className);
            String editedStyle = descriptor.getEditedStyleName(className);
            if (style == null) {
                style = defaultStyle;
            }
            e.setValue(STYLE_KEY, style);
            e.setValue(EDITED_STYLE_KEY, editedStyle);
            this.editedStyleFileMap.put(className, editedStyle);
        }
        if (descriptor.getBackgroundColor() != null) {
            this.setBackgroundColor(descriptor.getBackgroundColor());
        }
    }

    protected String getDefaultStyle(DisplayDescriptor descriptor) {
        String defaultStyle = null;
        if (descriptor.getDisplayType().equals("3D")) {
            defaultStyle = DefaultStyle3D.class.getName();
            this.setBackgroundColor(Color.BLACK);
        } else if (descriptor.getDisplayType().equals("2D")) {
            defaultStyle = DefaultStyleOGL2D.class.getName();
            this.setBackgroundColor(Color.WHITE);
        } else {
            VisualizationRegistryData data = VisualizationRegistry.getDataFor(descriptor.getDisplayType());
            if (data != null) {
                Class<?>[] defaultStyleClasses = data.getDefaultStyles();
                if (defaultStyleClasses != null) {
                    defaultStyle = defaultStyleClasses[0].getName();
                }
            } else {
                msg.error((Object)("Error creating style step for " + descriptor.getDisplayType() + ". No visualization registry data found."), null, new Object[0]);
            }
        }
        return defaultStyle;
    }

    protected List<String> findStylesFor(Class<?> styleInterface, String defaultStyle) {
        List<String> foundStyleClasses = styleCache.get(styleInterface);
        if (foundStyleClasses == null) {
            foundStyleClasses = StyleClassFinder.getAvailableStyles(this.model.getContext(), styleInterface);
            if (defaultStyle != null) {
                foundStyleClasses.add(defaultStyle);
            } else {
                msg.warn((Object)("No default styles found for " + this.model.getDescriptor().getDisplayType()), new Object[0]);
            }
            styleCache.put(styleInterface, foundStyleClasses);
        }
        return foundStyleClasses;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.bgcolorBtn.setIcon((Icon)new SquareIcon(14, 14, backgroundColor));
    }
}

