/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import repast.simphony.scenario.data.ContextData;
import repast.simphony.visualization.visualization3D.style.ValueLayerStyle3D;
import repast.simphony.visualizationOGL2D.ValueLayerStyleOGL;

public class StyleClassFinder {
    public static List<String> getAvailableStyles(ContextData context, Class<?> styleClass) {
        List<Class<?>> classes = StyleClassFinder.getClasses(context);
        ArrayList<String> names = new ArrayList<String>();
        for (Class<?> clazz : classes) {
            if (!styleClass.isAssignableFrom(clazz)) continue;
            names.add(clazz.getName());
        }
        return names;
    }

    private static List<Class<?>> getClasses(ContextData context) {
        List<Class<Object>> classes = new ArrayList();
        try {
            classes = context.getClasspath().getClasses();
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return classes;
    }

    public static List<String> getAvailable3DValueLayerStyles(ContextData context) {
        List<Class<?>> classes = StyleClassFinder.getClasses(context);
        ArrayList<String> names = new ArrayList<String>();
        for (Class<?> clazz : classes) {
            if (!ValueLayerStyle3D.class.isAssignableFrom(clazz)) continue;
            names.add(clazz.getName());
        }
        return names;
    }

    public static List<String> getAvailable2DValueLayerStyles(ContextData context) {
        List<Class<?>> classes = StyleClassFinder.getClasses(context);
        ArrayList<String> names = new ArrayList<String>();
        for (Class<?> clazz : classes) {
            if (!ValueLayerStyleOGL.class.isAssignableFrom(clazz)) continue;
            names.add(clazz.getName());
        }
        return names;
    }
}

