/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.gui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import org.pietschy.wizard.Wizard;
import org.pietschy.wizard.WizardListener;
import org.pietschy.wizard.WizardModel;
import org.pietschy.wizard.WizardStep;
import org.pietschy.wizard.models.Condition;
import repast.simphony.scenario.data.ContextData;
import repast.simphony.ui.plugin.editor.PluginWizard;
import repast.simphony.util.collections.Pair;
import repast.simphony.visualization.engine.DisplayDescriptor;
import repast.simphony.visualization.engine.VisualizationRegistry;
import repast.simphony.visualization.engine.VisualizationRegistryData;
import repast.simphony.visualization.gui.AgentSelectionStep;
import repast.simphony.visualization.gui.ContinuousStyleStep;
import repast.simphony.visualization.gui.DisplayWizardModel;
import repast.simphony.visualization.gui.EdgeStyleStep;
import repast.simphony.visualization.gui.GeneralStep;
import repast.simphony.visualization.gui.GridStyleStep;
import repast.simphony.visualization.gui.NetLayoutStep;
import repast.simphony.visualization.gui.ScheduleStep;
import repast.simphony.visualization.gui.StyleClassStep;
import repast.simphony.visualization.gui.ValueLayerStep;

public class DisplayConfigurationWizard {
    protected Wizard wizard;
    protected DisplayWizardModel model;

    public DisplayConfigurationWizard(Object contextID, DisplayDescriptor descriptor, ContextData rootContext) {
        this.model = new DisplayWizardModel(contextID, descriptor, rootContext);
        this.model.setLastVisible(false);
        this.addPaths();
        this.wizard = new PluginWizard((WizardModel)this.model);
        this.wizard.addWizardListener((WizardListener)this.model);
        this.wizard.setDefaultExitMode(2);
        this.wizard.setOverviewVisible(false);
    }

    public Wizard getWizard() {
        return this.wizard;
    }

    public DisplayWizardModel getModel() {
        return this.model;
    }

    protected List<Pair<WizardStep, Condition>> getPluginSteps() {
        ArrayList<Pair<WizardStep, Condition>> steps = new ArrayList<Pair<WizardStep, Condition>>();
        for (VisualizationRegistryData data : VisualizationRegistry.getRegistryData()) {
            steps.addAll(data.getDisplayWizardSteps());
        }
        return steps;
    }

    public static boolean isCartesian(DisplayDescriptor descriptor) {
        return descriptor.getDisplayType().equals("2D") || descriptor.getDisplayType().equals("3D");
    }

    protected List<Pair<WizardStep, Condition>> getCartesianSteps() {
        ArrayList<Pair<WizardStep, Condition>> steps = new ArrayList<Pair<WizardStep, Condition>>();
        AgentSelectionStep agentSelectionStep = new AgentSelectionStep();
        steps.add(this.pair((WizardStep)agentSelectionStep, new Condition(){

            public boolean evaluate(WizardModel wizardModel) {
                DisplayWizardModel model = (DisplayWizardModel)wizardModel;
                DisplayDescriptor descriptor = model.getDescriptor();
                return descriptor.getProjectionCount() > 0 && DisplayConfigurationWizard.isCartesian(descriptor);
            }
        }));
        StyleClassStep styleClassStep = new StyleClassStep();
        agentSelectionStep.addStepListener(styleClassStep);
        steps.add(this.pair((WizardStep)styleClassStep, new Condition(){

            public boolean evaluate(WizardModel wizardModel) {
                DisplayWizardModel model = (DisplayWizardModel)wizardModel;
                DisplayDescriptor descriptor = model.getDescriptor();
                return descriptor.getProjectionCount() > 0 && DisplayConfigurationWizard.isCartesian(descriptor);
            }
        }));
        steps.add(this.pair((WizardStep)new GridStyleStep(), new Condition(){

            public boolean evaluate(WizardModel wizardModel) {
                DisplayWizardModel model = (DisplayWizardModel)wizardModel;
                DisplayDescriptor descriptor = model.getDescriptor();
                return model.containsProjectionType("grid") && DisplayConfigurationWizard.isCartesian(descriptor);
            }
        }));
        steps.add(this.pair((WizardStep)new ContinuousStyleStep(), new Condition(){

            public boolean evaluate(WizardModel wizardModel) {
                DisplayWizardModel model = (DisplayWizardModel)wizardModel;
                DisplayDescriptor descriptor = model.getDescriptor();
                return model.containsProjectionType("continuous space") && DisplayConfigurationWizard.isCartesian(descriptor);
            }
        }));
        steps.add(this.pair((WizardStep)new NetLayoutStep(), new Condition(){

            public boolean evaluate(WizardModel wizardModel) {
                DisplayWizardModel model = (DisplayWizardModel)wizardModel;
                DisplayDescriptor descriptor = model.getDescriptor();
                return model.containsOnlyProjectionType("network") && DisplayConfigurationWizard.isCartesian(descriptor);
            }
        }));
        steps.add(this.pair((WizardStep)new EdgeStyleStep(), new Condition(){

            public boolean evaluate(WizardModel wizardModel) {
                DisplayWizardModel model = (DisplayWizardModel)wizardModel;
                DisplayDescriptor descriptor = model.getDescriptor();
                return model.containsProjectionType("network") && DisplayConfigurationWizard.isCartesian(descriptor);
            }
        }));
        return steps;
    }

    protected Pair<WizardStep, Condition> pair(WizardStep step, Condition condition) {
        return new Pair((Object)step, (Object)condition);
    }

    protected void addPaths() {
        this.model.add((WizardStep)new GeneralStep());
        for (Pair<WizardStep, Condition> step : this.getCartesianSteps()) {
            this.model.add((WizardStep)step.getFirst(), (Condition)step.getSecond());
        }
        for (Pair<WizardStep, Condition> step : this.getPluginSteps()) {
            this.model.add((WizardStep)step.getFirst(), (Condition)step.getSecond());
        }
        this.model.add((WizardStep)new ValueLayerStep(), new Condition(){

            public boolean evaluate(WizardModel wizardModel) {
                DisplayWizardModel model = (DisplayWizardModel)wizardModel;
                return model.containsValueLayer();
            }
        });
        this.model.add((WizardStep)new ScheduleStep());
    }

    public void showDialog(Component component) {
        this.wizard.showInDialog("Display Configuration", component, true);
    }

    public DisplayDescriptor getDescriptor() {
        return this.model.getDescriptor();
    }
}

