/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.grid;

import javax.vecmath.Point3f;
import repast.simphony.space.grid.Grid;
import repast.simphony.space.grid.GridDimensions;
import repast.simphony.space.grid.GridPoint;
import repast.simphony.visualization.Box;
import repast.simphony.visualization.Layout;
import repast.simphony.visualization.VisualizationProperties;

public class Grid3DLayout
implements Layout<Object, Grid> {
    private Grid grid;
    protected float[] point = new float[3];
    private Box box;
    private float cellSize = 0.06f;
    private VisualizationProperties visualizationProps;
    private Locator locator = new Locator2D();
    private double yDim;
    private double zDim;

    public void setProjection(Grid grid) {
        this.grid = grid;
        this.yDim = grid.getDimensions().getHeight();
        if (grid.getDimensions().size() == 3) {
            this.locator = new Locator3D();
            this.zDim = grid.getDimensions().getDepth();
        }
    }

    public void setLayoutProperties(VisualizationProperties props) {
        this.visualizationProps = props;
        Object obj = props.getProperty("cellSize");
        if (obj != null && obj instanceof Float) {
            this.cellSize = ((Float)obj).floatValue();
        }
    }

    public VisualizationProperties getLayoutProperties() {
        return this.visualizationProps;
    }

    public float[] getLocation(Object obj) {
        return this.locator.getLocation(obj);
    }

    public void update() {
    }

    public String getName() {
        return "Grid 3D";
    }

    public Box getBoundingBox() {
        if (this.box == null) {
            GridDimensions dims = this.grid.getDimensions();
            int[] origin = this.grid.getDimensions().originToIntArray(null);
            int xOffset = origin[0];
            int yOffset = origin[1];
            int zOffset = origin[3];
            this.box = new Box(new Point3f((float)xOffset * this.cellSize, (float)yOffset * this.cellSize, (float)zOffset * this.cellSize), new Point3f((float)(dims.getWidth() + xOffset) * this.cellSize, (float)(dims.getHeight() + xOffset) * this.cellSize, (float)(dims.getDepth() + zOffset) * this.cellSize));
        }
        return this.box;
    }

    static interface Locator {
        public float[] getLocation(Object var1);
    }

    class Locator2D
    implements Locator {
        Locator2D() {
        }

        @Override
        public float[] getLocation(Object obj) {
            GridPoint gpoint = Grid3DLayout.this.grid.getLocation(obj);
            int[] origin = Grid3DLayout.this.grid.getDimensions().originToIntArray(null);
            float xOffset = origin[0];
            float yOffset = origin[1];
            float x = ((float)gpoint.getX() + xOffset) * Grid3DLayout.this.cellSize;
            float z = (float)(Grid3DLayout.this.yDim - (double)((float)gpoint.getY() + yOffset)) * Grid3DLayout.this.cellSize;
            Grid3DLayout.this.point[0] = x;
            Grid3DLayout.this.point[2] = z;
            return Grid3DLayout.this.point;
        }
    }

    class Locator3D
    implements Locator {
        Locator3D() {
        }

        @Override
        public float[] getLocation(Object obj) {
            GridPoint gpoint = Grid3DLayout.this.grid.getLocation(obj);
            int[] origin = Grid3DLayout.this.grid.getDimensions().originToIntArray(null);
            float xOffset = origin[0];
            float yOffset = origin[1];
            float zOffset = origin[2];
            float x = ((float)gpoint.getX() + xOffset) * Grid3DLayout.this.cellSize;
            float y = ((float)gpoint.getY() + yOffset) * Grid3DLayout.this.cellSize;
            float z = (float)(Grid3DLayout.this.zDim - (double)((float)gpoint.getZ() + zOffset)) * Grid3DLayout.this.cellSize;
            Grid3DLayout.this.point[0] = x;
            Grid3DLayout.this.point[1] = y;
            Grid3DLayout.this.point[2] = z;
            return Grid3DLayout.this.point;
        }
    }
}

