/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.grid;

import javax.vecmath.Point3f;
import repast.simphony.space.grid.Grid;
import repast.simphony.space.grid.GridDimensions;
import repast.simphony.space.grid.GridPoint;
import repast.simphony.visualization.Box;
import repast.simphony.visualization.Layout;
import repast.simphony.visualization.VisualizationProperties;

public class Grid2DLayout
implements Layout<Object, Grid> {
    private Grid grid;
    protected float[] point = new float[2];
    private float cellSize = 15.0f;
    private VisualizationProperties visualizationProps;
    private float centerShift;
    private Box box;

    public Grid2DLayout() {
    }

    public Grid2DLayout(Grid grid) {
        this.grid = grid;
    }

    public void setProjection(Grid grid) {
        this.grid = grid;
    }

    public void setLayoutProperties(VisualizationProperties props) {
        this.visualizationProps = props;
        Object obj = props.getProperty("cellSize");
        if (obj != null && obj instanceof Float) {
            this.cellSize = ((Float)obj).floatValue();
        }
        this.centerShift = this.cellSize / 2.0f;
    }

    public VisualizationProperties getLayoutProperties() {
        return this.visualizationProps;
    }

    public float[] getLocation(Object obj) {
        GridPoint gpoint = this.grid.getLocation(obj);
        int[] origin = this.grid.getDimensions().originToIntArray(null);
        float xOffset = origin[0];
        float yOffset = origin[1];
        if (gpoint == null) {
            this.point[0] = Float.POSITIVE_INFINITY;
            this.point[1] = Float.POSITIVE_INFINITY;
            return this.point;
        }
        float x = ((float)gpoint.getX() + xOffset) * this.cellSize + this.centerShift;
        float y = ((float)gpoint.getY() + yOffset) * this.cellSize + this.centerShift;
        this.point[0] = x;
        this.point[1] = y;
        return this.point;
    }

    public void update() {
    }

    public String getName() {
        return "Grid 2D";
    }

    public Box getBoundingBox() {
        if (this.box == null) {
            GridDimensions dims = this.grid.getDimensions();
            int[] origin = this.grid.getDimensions().originToIntArray(null);
            int xOffset = origin[0];
            int yOffset = origin[1];
            this.box = new Box(new Point3f((float)xOffset * this.cellSize, (float)yOffset * this.cellSize, 0.0f), new Point3f((float)(dims.getWidth() + xOffset) * this.cellSize, (float)(dims.getHeight() + xOffset) * this.cellSize, 0.0f));
        }
        return this.box;
    }
}

