/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.engine;

import java.awt.Color;
import repast.simphony.context.Context;
import repast.simphony.space.graph.Network;
import repast.simphony.space.projection.Projection;
import repast.simphony.valueLayer.ValueLayer;
import repast.simphony.visualization.DefaultDisplayData;
import repast.simphony.visualization.IDisplay;
import repast.simphony.visualization.Layout;
import repast.simphony.visualization.decorator.ProjectionDecorator2D;
import repast.simphony.visualization.engine.AbstractCartesianDisplayCreator;
import repast.simphony.visualization.engine.CartesianDisplayDescriptor;
import repast.simphony.visualization.engine.DisplayCreationException;
import repast.simphony.visualization.engine.NetworkStyleRegistrar;
import repast.simphony.visualization.engine.NetworkStyleRegistrar2D;
import repast.simphony.visualization.engine.ProjectionDescriptor;
import repast.simphony.visualization.engine.StyleRegistrar;
import repast.simphony.visualization.engine.StyleRegistrar2D;
import repast.simphony.visualization.engine.VLStyleRegistrar;
import repast.simphony.visualization.engine.VLStyleRegistrar2D;
import repast.simphony.visualization.visualization2D.Display2D;
import repast.simphony.visualization.visualization2D.style.EdgeStyle2D;
import repast.simphony.visualization.visualization2D.style.Style2D;
import repast.simphony.visualization.visualization2D.style.ValueLayerStyle;

public class DisplayCreator2D
extends AbstractCartesianDisplayCreator {
    public DisplayCreator2D(Context<?> context, CartesianDisplayDescriptor descriptor) {
        super(context, descriptor);
    }

    private void registerProjectionDecorators(Display2D display) {
        for (ProjectionDescriptor projDesc : this.descriptor.getProjectionDescriptors()) {
            String name = projDesc.getProjectionName();
            for (ProjectionDecorator2D deco : projDesc.get2DDecorators()) {
                Projection projection = this.context.getProjection(name);
                deco.setProjection(projection);
                display.registerDecorator(deco);
            }
        }
    }

    @Override
    public IDisplay createDisplay() throws DisplayCreationException {
        try {
            DefaultDisplayData<?> data = this.createDisplayData();
            Layout layout = null;
            if (data.getProjectionCount() > 0) {
                String layoutProj = this.descriptor.getLayoutProjection();
                ProjectionDescriptor projDesc = this.descriptor.getProjectionDescriptor(layoutProj);
                String layoutClassName = projDesc.getImpliedLayout2D();
                layout = this.createLayout(layoutClassName);
            } else {
                layout = new Layout();
            }
            final Display2D display = new Display2D(data, layout);
            VLStyleRegistrar2D vlReg = new VLStyleRegistrar2D();
            vlReg.registerValueLayerStyle(new VLStyleRegistrar.Registrar<ValueLayerStyle>(){

                @Override
                public void register(ValueLayerStyle style, ValueLayer layer) {
                    style.addValueLayer(layer);
                    display.registerValueLayerStyle(style);
                }
            }, this.descriptor, this.context);
            StyleRegistrar2D styleReg = new StyleRegistrar2D();
            styleReg.registerStyles(new StyleRegistrar.Registrar<Style2D<?>>(){

                @Override
                public void register(Class<?> agentClass, Style2D<?> style) {
                    display.registerStyle(agentClass, style);
                }
            }, this.descriptor);
            NetworkStyleRegistrar2D netReg = new NetworkStyleRegistrar2D();
            netReg.registerNetworkStyles(new NetworkStyleRegistrar.Registrar<EdgeStyle2D>(){

                @Override
                public void register(Network<?> network, EdgeStyle2D style) {
                    display.registerNetworkStyle(network, style);
                }
            }, this.descriptor, this.context);
            display.setLayoutFrequency(this.descriptor.getLayoutFrqeuency(), this.descriptor.getLayoutInterval());
            Color color = this.descriptor.getBackgroundColor();
            if (color != null) {
                display.setBackgroundColor(color);
            }
            return display;
        }
        catch (Exception ex) {
            throw new DisplayCreationException(ex);
        }
    }
}

