/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.engine;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import repast.simphony.engine.controller.DescriptorControllerAction;
import repast.simphony.engine.environment.DefaultControllerAction;
import repast.simphony.engine.environment.GUIRegistryType;
import repast.simphony.engine.environment.RunState;
import repast.simphony.engine.schedule.IAction;
import repast.simphony.engine.schedule.ISchedulableAction;
import repast.simphony.engine.schedule.NonModelAction;
import repast.simphony.parameter.Parameters;
import repast.simphony.visualization.IDisplay;
import repast.simphony.visualization.engine.DisplayDescriptor;
import repast.simphony.visualization.engine.DisplayProducer;
import repast.simphony.visualization.engine.VisualizationRegistry;
import simphony.util.messages.MessageCenter;

public class DisplayComponentControllerAction
extends DefaultControllerAction
implements DescriptorControllerAction<DisplayDescriptor> {
    private static final MessageCenter msg = MessageCenter.getMessageCenter(DisplayComponentControllerAction.class);
    private List<DisplayUpdater> displays = new ArrayList<DisplayUpdater>();
    private DisplayDescriptor descriptor;
    private ISchedulableAction displayUpdate;

    public DisplayComponentControllerAction(DisplayDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void runCleanup(RunState runState, Object contextId) {
        if (this.displayUpdate != null) {
            runState.getScheduleRegistry().getModelSchedule().removeAction(this.displayUpdate);
        }
        for (DisplayUpdater updater : this.displays) {
            updater.display.destroy();
            updater.display = null;
        }
        this.displays.clear();
        this.displayUpdate = null;
    }

    public void runInitialize(RunState runState, Object contextId, Parameters params) {
        if (!runState.getRunInfo().isBatch()) {
            if (this.descriptor.getDisplayType().equals("3D")) {
                try {
                    Class.forName("com.sun.j3d.utils.behaviors.mouse.MouseWheelZoom");
                }
                catch (ClassNotFoundException e) {
                    JOptionPane.showMessageDialog(null, "Java3D 1.6 (java3d.dev.java.net) is required for 3D displays.\nAborting 3D display creation of '" + this.descriptor.getName() + "'.");
                    return;
                }
            }
            if (this.descriptor.getDisplayType().equals("2D")) {
                try {
                    Class.forName("javax.media.opengl.glu.GLU");
                }
                catch (ClassNotFoundException e) {
                    JOptionPane.showMessageDialog(null, "JOGL (jogl.dev.java.net) is required for 2D displays.\nAborting display creation of '" + this.descriptor.getName() + "'.");
                    return;
                }
            }
            String requiredClassName = VisualizationRegistry.getDataFor(this.descriptor.getDisplayType()).getRequiredLibraryClassName();
            if (requiredClassName != null && requiredClassName.length() > 0) {
                try {
                    Class.forName(requiredClassName);
                }
                catch (ClassNotFoundException e) {
                    JOptionPane.showMessageDialog(null, String.valueOf(requiredClassName) + " is required for " + this.descriptor.getDisplayType() + " displays." + "\nAborting display creation of '" + this.descriptor.getName() + "'.");
                    return;
                }
            }
            DisplayProducer creator = new DisplayProducer(contextId, runState, this.descriptor);
            try {
                IDisplay display = creator.createDisplay();
                display.init();
                String contextName = contextId.toString();
                if (contextName.equals("default_observer_context")) {
                    contextName = "ReLogo";
                }
                runState.getGUIRegistry().addDisplay(String.valueOf(contextName) + ": " + this.descriptor.getName(), GUIRegistryType.DISPLAY, display);
                DisplayUpdater updater = new DisplayUpdater(display);
                this.displayUpdate = runState.getScheduleRegistry().getModelSchedule().schedule(this.descriptor.getScheduleParameters(), (IAction)updater);
                this.displays.add(updater);
            }
            catch (Exception ex) {
                msg.error((Object)"Error while creating displays", (Throwable)ex, new Object[0]);
            }
        }
    }

    public DisplayDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(DisplayDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @NonModelAction
    static class DisplayUpdater
    implements IAction {
        IDisplay display;

        public DisplayUpdater(IDisplay display) {
            this.display = display;
        }

        public void execute() {
            this.display.update();
        }
    }
}

