/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.engine;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import repast.simphony.engine.schedule.ScheduleParameters;
import repast.simphony.scenario.AbstractDescriptor;
import repast.simphony.scenario.data.ProjectionData;
import repast.simphony.visualization.IDisplay;
import repast.simphony.visualization.VisualizationProperties;
import repast.simphony.visualization.engine.BoundingBox;
import repast.simphony.visualization.engine.DisplayDescriptor;
import repast.simphony.visualization.engine.ProjectionDescriptor;

public abstract class BasicDisplayDescriptor
extends AbstractDescriptor
implements DisplayDescriptor {
    private static Class<?>[] defaultStyles;
    private static Class<?>[] defaultNetStyles;
    private String type = "2D";
    private Map<String, String> styles = new HashMap<String, String>();
    private Map<String, String> editedStyles = new HashMap<String, String>();
    private Map<Object, String> netStyles = new HashMap<Object, String>();
    private Map<Object, String> editedNetStyles = new HashMap<Object, String>();
    private IDisplay.LayoutFrequency frequency = IDisplay.LayoutFrequency.ON_NEW;
    private ScheduleParameters schedParams = ScheduleParameters.createRepeating((double)1.0, (double)1.0, (double)Double.NEGATIVE_INFINITY);
    private String layoutClassName;
    private String layoutProjection;
    private int layoutInterval = 0;
    private Map<String, Integer> layerOrder = new HashMap<String, Integer>();
    private List<ProjectionData> projections = new ArrayList<ProjectionData>();
    private VisualizationProperties visualizationProperties = null;
    private Map<String, ProjectionDescriptor> projectionDescriptors = new HashMap<String, ProjectionDescriptor>();
    private BoundingBox boundingBox = null;
    private Map<String, Object> props = new HashMap<String, Object>();
    private Color backgroundColor = null;

    public BasicDisplayDescriptor(DisplayDescriptor descriptor) {
        super(descriptor.getName());
    }

    public BasicDisplayDescriptor(String name) {
        super(name);
    }

    @Override
    public Iterable<ProjectionData> getProjections() {
        return this.projections;
    }

    @Override
    public int getProjectionCount() {
        return this.projections.size();
    }

    @Override
    public void addProjection(ProjectionData data, ProjectionDescriptor descriptor) {
        this.projections.add(data);
        this.projectionDescriptors.put(descriptor.getProjectionName(), descriptor);
    }

    @Override
    public void clearProjections() {
        if (this.projections.size() > 0) {
            this.projections.clear();
            this.scs.fireScenarioChanged((Object)this, "projections");
        }
    }

    @Override
    public ProjectionDescriptor getProjectionDescriptor(String name) {
        return this.projectionDescriptors.get(name);
    }

    @Override
    public void clearProjectionDescriptors() {
        this.projectionDescriptors.clear();
    }

    @Override
    public Iterable<ProjectionDescriptor> getProjectionDescriptors() {
        return this.projectionDescriptors.values();
    }

    @Override
    public void set(DisplayDescriptor descriptor) {
        this.setScheduleParameters(descriptor.getScheduleParameters());
        this.setName(descriptor.getName());
        this.setDisplayType(descriptor.getDisplayType());
        this.setLayoutClassName(descriptor.getLayoutClassName());
        this.setLayoutFrequency(descriptor.getLayoutFrqeuency());
        this.setLayoutInterval(descriptor.getLayoutInterval());
        this.setLayoutProjection(descriptor.getLayoutProjection());
        this.setLayoutProperties(descriptor.getLayoutProperties());
        this.styles.clear();
        for (String string : descriptor.agentClassStyleNames()) {
            this.addStyle(string, descriptor.getStyleClassName(string));
        }
        this.netStyles.clear();
        for (Object object : descriptor.networkStyleIDs()) {
            this.addNetworkStyle(object, descriptor.getNetworkStyleClassName(object));
        }
        this.editedStyles.clear();
        if (descriptor.agentClassEditedStyleNames() != null) {
            for (String string : descriptor.agentClassEditedStyleNames()) {
                this.addEditedStyle(string, descriptor.getEditedStyleName(string));
            }
        }
        this.editedNetStyles.clear();
        if (descriptor.networkEditedStyleIDs() != null) {
            for (Object object : descriptor.networkEditedStyleIDs()) {
                this.addNetworkEditedStyle(object, descriptor.getNetworkEditedStyleName(object));
            }
        }
        for (ProjectionData projectionData : descriptor.getProjections()) {
            this.addProjection(projectionData, descriptor.getProjectionDescriptor(projectionData.getId()));
        }
        for (String string : descriptor.propertyNames()) {
            this.setProperty(string, descriptor.getProperty(string));
        }
        this.setBackgroundColor(descriptor.getBackgroundColor());
    }

    @Override
    public String getDisplayType() {
        return this.type;
    }

    private void setDisplayType(String type) {
        if (this.type != type) {
            this.type = type;
            this.scs.fireScenarioChanged((Object)this, "displayType");
        }
    }

    @Override
    public void setDisplayType(String type, boolean reset) {
        this.setDisplayType(type);
        if (reset) {
            this.styles.clear();
            this.editedStyles.clear();
            this.netStyles.clear();
            this.editedNetStyles.clear();
            this.layerOrder.clear();
            this.layoutClassName = null;
            this.scs.fireScenarioChanged((Object)this, "displayTypeReset");
        }
    }

    @Override
    public void addStyle(String objClassName, String styleClassName) {
        if (!this.mapContains(this.styles, objClassName, styleClassName)) {
            this.styles.put(objClassName, styleClassName);
            this.scs.fireScenarioChanged((Object)this, "style");
        }
    }

    @Override
    public void addEditedStyle(String objClassName, String userStyleName) {
        if (!this.mapContains(this.editedStyles, objClassName, userStyleName)) {
            this.editedStyles.put(objClassName, userStyleName);
            this.scs.fireScenarioChanged((Object)this, "editedStyle");
        }
    }

    private boolean mapContains(Map<String, String> map, String key, String value) {
        String val = map.get(key);
        return val != null && val.equals(value);
    }

    @Override
    public void addNetworkStyle(Object networkID, String networkClassName) {
        String val = this.netStyles.get(networkID);
        if (val == null || !val.equals(networkClassName)) {
            this.netStyles.put(networkID, networkClassName);
            this.scs.fireScenarioChanged((Object)this, "netStyle");
        }
    }

    @Override
    public void addNetworkEditedStyle(Object networkID, String networkClassName) {
        String val = this.editedNetStyles.get(networkID);
        if (val == null || !val.equals(networkClassName)) {
            this.editedNetStyles.put(networkID, networkClassName);
            this.scs.fireScenarioChanged((Object)this, "editedNetStyle");
        }
    }

    @Override
    public String getStyleClassName(String objClassName) {
        return this.styles.get(objClassName);
    }

    @Override
    public String getEditedStyleName(String objClassName) {
        if (this.editedStyles == null) {
            return null;
        }
        return this.editedStyles.get(objClassName);
    }

    @Override
    public String getNetworkStyleClassName(Object networkID) {
        return this.netStyles.get(networkID);
    }

    @Override
    public String getNetworkEditedStyleName(Object networkID) {
        if (this.editedNetStyles == null) {
            return null;
        }
        return this.editedNetStyles.get(networkID);
    }

    @Override
    public Iterable<String> agentClassStyleNames() {
        return this.styles.keySet();
    }

    @Override
    public Iterable<String> agentClassEditedStyleNames() {
        if (this.editedStyles == null) {
            return null;
        }
        return this.editedStyles.keySet();
    }

    @Override
    public Iterable<Object> networkStyleIDs() {
        return this.netStyles.keySet();
    }

    @Override
    public Iterable<Object> networkEditedStyleIDs() {
        if (this.editedNetStyles == null) {
            return null;
        }
        return this.editedNetStyles.keySet();
    }

    @Override
    public IDisplay.LayoutFrequency getLayoutFrqeuency() {
        return this.frequency;
    }

    @Override
    public void setLayoutFrequency(IDisplay.LayoutFrequency frequency) {
        if (this.frequency != frequency) {
            this.frequency = frequency;
            this.scs.fireScenarioChanged((Object)this, "layoutFrequency");
        }
    }

    @Override
    public ScheduleParameters getScheduleParameters() {
        return this.schedParams;
    }

    @Override
    public void setScheduleParameters(ScheduleParameters scheduleInfo) {
        if (!this.schedParams.equals((Object)scheduleInfo)) {
            this.schedParams = scheduleInfo;
            this.scs.fireScenarioChanged((Object)this, "scheduleParameters");
        }
    }

    @Override
    public String getLayoutClassName() {
        return this.layoutClassName;
    }

    @Override
    public void setLayoutClassName(String className) {
        this.layoutClassName = className;
        this.scs.fireScenarioChanged((Object)this, "layoutClassName");
    }

    @Override
    public String getLayoutProjection() {
        return this.layoutProjection;
    }

    @Override
    public void setLayoutProjection(String layoutProjection) {
        this.layoutProjection = layoutProjection;
        this.scs.fireScenarioChanged((Object)this, "layoutProjection");
    }

    @Override
    public void setLayoutInterval(int interval) {
        this.layoutInterval = interval;
        this.scs.fireScenarioChanged((Object)this, "layoutInterval");
    }

    @Override
    public int getLayoutInterval() {
        return this.layoutInterval;
    }

    @Override
    public VisualizationProperties getLayoutProperties() {
        return this.visualizationProperties;
    }

    @Override
    public void setLayoutProperties(VisualizationProperties props) {
        this.visualizationProperties = props;
        this.scs.fireScenarioChanged((Object)this, "layoutProperties");
    }

    @Override
    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public void setBoundingBox(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
        this.scs.fireScenarioChanged((Object)this, "boundingBox");
    }

    @Override
    public Iterable<String> agentClassLayerOrders() {
        if (this.layerOrder == null) {
            return null;
        }
        return this.layerOrder.keySet();
    }

    @Override
    public Integer getLayerOrder(String objClassName) {
        if (this.layerOrder == null) {
            return null;
        }
        return this.layerOrder.get(objClassName);
    }

    @Override
    public void addLayerOrder(String objClassName, int order) {
        this.layerOrder.put(objClassName, order);
        this.scs.fireScenarioChanged((Object)this, "layerOrder");
    }

    @Override
    public Object getProperty(String name) {
        return this.props.get(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.props.put(name, value);
        this.scs.fireScenarioChanged((Object)this, "property");
    }

    @Override
    public Iterable<String> propertyNames() {
        return this.props.keySet();
    }

    @Override
    public Map<String, String> getStyles() {
        return this.styles;
    }

    @Override
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        this.scs.fireScenarioChanged((Object)this, "backgroundColor");
    }

    @Override
    public Map<String, Integer> getLayerOrders() {
        return this.layerOrder;
    }

    @Override
    public Map<String, String> getEditedStyles() {
        return this.editedStyles;
    }

    @Override
    public Class<?>[] getDefaultStyles() {
        return defaultStyles;
    }

    @Override
    public Class<?>[] getDefaultNetStyles() {
        return defaultNetStyles;
    }
}

