/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import repast.simphony.scenario.data.ProjectionData;
import repast.simphony.visualization.decorator.ProjectionDecorator2D;
import repast.simphony.visualization.decorator.ProjectionDecorator3D;
import repast.simphony.visualization.decorator.ProjectionDecoratorFactory;
import repast.simphony.visualization.engine.ProjectionDescriptor;

public abstract class AbstractProjectionDescriptor
implements ProjectionDescriptor {
    private ProjectionData proj;
    protected Map<String, Map<String, Object>> props = new HashMap<String, Map<String, Object>>();

    protected AbstractProjectionDescriptor(ProjectionData proj) {
        this.proj = proj;
        if (proj == null) {
            throw new IllegalArgumentException("Projection cannot be null.");
        }
    }

    @Override
    public String getProjectionName() {
        return this.proj.getId();
    }

    @Override
    public Object getProperty(String groupID, String key) {
        Map<String, Object> map = this.props.get(groupID);
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    @Override
    public void setProperty(String groupID, String key, Object value) {
        Map<String, Object> map = this.props.get(groupID);
        if (map == null) {
            map = new HashMap<String, Object>();
            this.props.put(groupID, map);
        }
        map.put(key, value);
    }

    @Override
    public Iterable<ProjectionDecorator2D> get2DDecorators() {
        ArrayList<ProjectionDecorator2D> list = new ArrayList<ProjectionDecorator2D>();
        ProjectionDecoratorFactory fac = new ProjectionDecoratorFactory();
        for (String key : this.props.keySet()) {
            ProjectionDecorator2D<?> deco = fac.create2DDecorator(key, this.props.get(key));
            if (deco == null) continue;
            list.add(deco);
        }
        return list;
    }

    @Override
    public Iterable<ProjectionDecorator3D> get3DDecorators() {
        ArrayList<ProjectionDecorator3D> list = new ArrayList<ProjectionDecorator3D>();
        ProjectionDecoratorFactory fac = new ProjectionDecoratorFactory();
        for (String key : this.props.keySet()) {
            ProjectionDecorator3D<?> deco = fac.create3DDecorator(key, this.props.get(key));
            if (deco == null) continue;
            list.add(deco);
        }
        return list;
    }
}

