/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.engine;

import repast.simphony.context.Context;
import repast.simphony.scenario.data.ProjectionData;
import repast.simphony.space.projection.Projection;
import repast.simphony.visualization.DefaultDisplayData;
import repast.simphony.visualization.Layout;
import repast.simphony.visualization.engine.CartesianDisplayDescriptor;
import repast.simphony.visualization.engine.DisplayCreator;

public abstract class AbstractCartesianDisplayCreator
implements DisplayCreator {
    protected Context<?> context;
    protected CartesianDisplayDescriptor descriptor;

    public AbstractCartesianDisplayCreator(Context<?> context, CartesianDisplayDescriptor descriptor) {
        this.context = context;
        this.descriptor = descriptor;
    }

    protected DefaultDisplayData<?> createDisplayData() {
        DefaultDisplayData data = new DefaultDisplayData(this.context);
        for (ProjectionData pData : this.descriptor.getProjections()) {
            data.addProjection(pData.getId());
        }
        for (String vlName : this.descriptor.getValueLayerNames()) {
            data.addValueLayer(vlName);
        }
        return data;
    }

    protected Layout<?, ? extends Projection<?>> createLayout(String layoutClassName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> clazz;
        if (layoutClassName == null || layoutClassName.length() == 0) {
            layoutClassName = this.descriptor.getLayoutClassName();
        }
        if (!Layout.class.isAssignableFrom(clazz = Class.forName(layoutClassName, true, this.getClass().getClassLoader()))) {
            throw new IllegalArgumentException("Layout class must implements Layout interface.");
        }
        Layout layout = (Layout)clazz.newInstance();
        String layoutProj = this.descriptor.getLayoutProjection();
        Projection projection = this.context.getProjection(layoutProj);
        if (projection == null) {
            throw new RuntimeException("Projection '" + layoutProj + "' not found.");
        }
        layout.setProjection(projection);
        layout.setLayoutProperties(this.descriptor.getLayoutProperties());
        return layout;
    }
}

