/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.editor;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import repast.simphony.space.graph.Network;
import repast.simphony.space.projection.DefaultProjection;
import repast.simphony.space.projection.Projection;
import repast.simphony.visualization.editor.DisplayEditor;

public class VizEditorForm
extends JPanel {
    private ButtonGroup buttonGroup1;
    private static final String SELECT_ICON = "select.png";
    private static final String MOVE_ICON = "move.png";
    private static final String LINK_ICON = "link_16.png";
    private static final String MODE_KEY = "MODE_KEY";
    private DisplayEditor editor;
    private DisplayEditor.Mode mode;
    private Map<DisplayEditor.Mode, JToggleButton> modeMap = new HashMap<DisplayEditor.Mode, JToggleButton>();
    private JToolBar toolBar1;
    private JToggleButton selectBtn;
    private JToggleButton moveBtn;
    private JSeparator separator1;
    private JToggleButton addEdgeBtn;
    private JComboBox netBox;

    public VizEditorForm() {
        this.initComponents();
        this.selectBtn.setIcon(new ImageIcon(VizEditorForm.class.getClassLoader().getResource(SELECT_ICON)));
        this.selectBtn.setToolTipText("Select agent or link");
        this.moveBtn.setIcon(new ImageIcon(VizEditorForm.class.getClassLoader().getResource(MOVE_ICON)));
        this.moveBtn.setToolTipText("Move agent");
        this.addEdgeBtn.setIcon(new ImageIcon(VizEditorForm.class.getClassLoader().getResource(LINK_ICON)));
        this.addEdgeBtn.setToolTipText("Add link");
        this.addEdgeBtn.setText(null);
        this.modeMap.put(DisplayEditor.Mode.SELECT, this.selectBtn);
        this.selectBtn.putClientProperty(MODE_KEY, (Object)DisplayEditor.Mode.SELECT);
        this.modeMap.put(DisplayEditor.Mode.MOVE, this.moveBtn);
        this.moveBtn.putClientProperty(MODE_KEY, (Object)DisplayEditor.Mode.MOVE);
        this.modeMap.put(DisplayEditor.Mode.ADD_EDGE, this.addEdgeBtn);
        this.addEdgeBtn.putClientProperty(MODE_KEY, (Object)DisplayEditor.Mode.ADD_EDGE);
    }

    private void initComponents() {
        this.toolBar1 = new JToolBar();
        this.selectBtn = new JToggleButton();
        this.moveBtn = new JToggleButton();
        this.separator1 = new JSeparator();
        this.addEdgeBtn = new JToggleButton();
        this.netBox = new JComboBox();
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)new FormLayout("59dlu:grow", "top:default:grow"));
        this.toolBar1.setFloatable(false);
        this.toolBar1.add(this.selectBtn);
        this.toolBar1.add(this.moveBtn);
        this.separator1.setMaximumSize(new Dimension(2, 1));
        this.separator1.setPreferredSize(new Dimension(2, 0));
        this.toolBar1.add(this.separator1);
        this.addEdgeBtn.setText("e");
        this.addEdgeBtn.setEnabled(false);
        this.toolBar1.add(this.addEdgeBtn);
        this.toolBar1.add(this.netBox);
        this.add((Component)this.toolBar1, cc.xy(1, 1));
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup1.add(this.selectBtn);
        this.buttonGroup1.add(this.moveBtn);
        this.buttonGroup1.add(this.addEdgeBtn);
    }

    public ButtonGroup getButtonGroup() {
        return this.buttonGroup1;
    }

    public void init(DisplayEditor editor, List<Network> networks) {
        this.editor = editor;
        if (networks.size() > 0) {
            DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(networks.toArray());
            this.netBox.setModel(model);
            this.netBox.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    if (value != null) {
                        value = ((Projection)value).getName();
                    }
                    return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                }
            });
            this.netBox.setSelectedIndex(0);
            this.netBox.setPrototypeDisplayValue(new DefaultProjection("XXXXXXXXXXXXXXXXXXXX"));
            this.netBox.setMaximumSize(this.netBox.getPreferredSize());
        } else {
            this.netBox.setEnabled(false);
        }
        this.addListeners();
        this.selectBtn.setSelected(true);
        editor.modeSwitched(DisplayEditor.Mode.SELECT);
        this.mode = DisplayEditor.Mode.SELECT;
    }

    public DisplayEditor.Mode getMode() {
        return this.mode;
    }

    public void setAddEdgeEnabled(boolean enabled) {
        this.addEdgeBtn.setEnabled(enabled);
    }

    public void setMoveEnabled(boolean enabled) {
        this.moveBtn.setEnabled(enabled);
    }

    public void setMode(DisplayEditor.Mode mode) {
        this.mode = mode;
        this.modeMap.get((Object)mode).setSelected(true);
        this.editor.modeSwitched(mode);
    }

    private void addListeners() {
        ButtonListener bListener = new ButtonListener();
        this.selectBtn.addActionListener(bListener);
        this.moveBtn.addActionListener(bListener);
        this.addEdgeBtn.addActionListener(bListener);
        this.netBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VizEditorForm.this.editor.netSelected((Network)VizEditorForm.this.netBox.getSelectedItem());
            }
        });
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JToggleButton btn = (JToggleButton)e.getSource();
            DisplayEditor.Mode mode = btn.isSelected() ? (DisplayEditor.Mode)((Object)btn.getClientProperty(VizEditorForm.MODE_KEY)) : DisplayEditor.Mode.NONE;
            VizEditorForm.this.editor.modeSwitched(mode);
        }
    }
}

