/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.editor;

import repast.simphony.space.continuous.ContinuousAdder;
import repast.simphony.space.continuous.ContinuousSpace;
import repast.simphony.visualization.editor.AddListener;
import repast.simphony.visualization.editor.PEditorEventListener;
import repast.simphony.visualization.editor.SpaceAddHandler;
import repast.simphony.visualization.editor.space.Projected3DSpace;

public class SpaceAddListener
implements AddListener {
    private ContinuousSpace space;
    private ContinuousAdder adder;
    private LocationAdder locAdder;
    private int constantIndex = -1;
    private int dimIndex1;
    private int dimIndex2;
    private double[] location;
    private SpaceAddHandler handler;

    public SpaceAddListener(ContinuousSpace space, SpaceAddHandler handler) {
        this.space = space;
        this.adder = space.getAdder();
        if (space instanceof Projected3DSpace) {
            this.location = new double[3];
            Projected3DSpace pSpace = (Projected3DSpace)space;
            this.constantIndex = pSpace.getConstantIndex();
            this.dimIndex1 = pSpace.getIndex1();
            this.dimIndex2 = pSpace.getIndex2();
        } else {
            this.location = new double[space.getDimensions().size()];
        }
        this.locAdder = new LocationAdder();
        this.handler = handler;
    }

    @Override
    public boolean preAdd(Object obj, double ... point) {
        if (this.constantIndex == -1) {
            int i = 0;
            while (i < this.location.length) {
                this.location[i] = point[i];
                ++i;
            }
        } else {
            this.location[this.constantIndex] = 0.0;
            this.location[this.dimIndex1] = point[0];
            this.location[this.dimIndex2] = point[1];
        }
        this.locAdder.initLocation(this.location);
        this.space.setAdder((ContinuousAdder)this.locAdder);
        return true;
    }

    @Override
    public void postAdd() {
        this.space.setAdder(this.adder);
    }

    @Override
    public PEditorEventListener getAddHandler() {
        return this.handler;
    }

    class LocationAdder<Object>
    implements ContinuousAdder<Object> {
        private double[] location;

        LocationAdder() {
        }

        public void initLocation(double[] location) {
            this.location = location;
        }

        public void add(ContinuousSpace<Object> space, Object object) {
            space.moveTo(object, this.location);
        }
    }
}

