/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.editor;

import java.awt.Cursor;
import java.awt.geom.Point2D;
import org.piccolo2d.PCamera;
import org.piccolo2d.PCanvas;
import org.piccolo2d.PNode;
import org.piccolo2d.event.PBasicInputEventHandler;
import org.piccolo2d.event.PInputEvent;
import org.piccolo2d.event.PInputEventListener;
import repast.simphony.space.continuous.ContinuousSpace;
import repast.simphony.visualization.editor.DisplayEditor2D;
import repast.simphony.visualization.editor.PEditorEventListener;
import repast.simphony.visualization.visualization2D.Display2D;

public class SpaceAddHandler
extends PBasicInputEventHandler
implements PEditorEventListener {
    private ContinuousSpace space;
    private boolean shapeFound;
    private PCamera camera;
    private PNode shape;
    private DisplayEditor2D editor;
    private PCanvas canvas;
    private float unitSize;

    public SpaceAddHandler(PCanvas canvas, Display2D display, DisplayEditor2D editor, ContinuousSpace space) {
        this.space = space;
        this.camera = canvas.getCamera();
        this.editor = editor;
        this.canvas = canvas;
        this.unitSize = ((Float)display.getLayout().getLayoutProperties().getProperty("cellSize")).floatValue();
    }

    @Override
    public void init() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void start() {
        this.camera.addInputEventListener((PInputEventListener)this);
        this.canvas.setCursor(Cursor.getPredefinedCursor(1));
    }

    @Override
    public void stop() {
        this.camera.removeInputEventListener((PInputEventListener)this);
        this.canvas.setCursor(Cursor.getDefaultCursor());
    }

    public void mouseClicked(PInputEvent evt) {
        if (evt.isLeftMouseButton()) {
            Point2D xy = evt.getPosition();
            if (xy != null) {
                double x = xy.getX() / (double)this.unitSize;
                double y = xy.getY() / (double)this.unitSize;
                double[] origin = this.space.getDimensions().originToDoubleArray(null);
                double xOffset = origin[0];
                double yOffset = origin[1];
                if (x < this.space.getDimensions().getWidth() && x >= 0.0 && y < this.space.getDimensions().getHeight() && y >= 0.0) {
                    this.editor.addAgentAt(x - xOffset, y - yOffset);
                }
            }
        } else if (evt.isRightMouseButton()) {
            this.editor.addCanceled();
        }
    }
}

