/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.piccolo2d.PCanvas;
import org.piccolo2d.PNode;
import org.piccolo2d.event.PBasicInputEventHandler;
import org.piccolo2d.event.PInputEvent;
import org.piccolo2d.event.PInputEventListener;
import org.piccolo2d.util.PNodeFilter;
import org.piccolo2d.util.PStack;
import repast.simphony.visualization.editor.PEditorEventListener;
import repast.simphony.visualization.editor.PNodeSelectionListener;
import repast.simphony.visualization.editor.PNodeSelector;

public class SelectionHandler
extends PBasicInputEventHandler
implements PEditorEventListener {
    private PCanvas canvas;
    private List<PNodeSelectionListener> listeners = new ArrayList<PNodeSelectionListener>();
    private boolean fireSelected = true;
    private PNodeSelector selector = new PNodeSelector();

    public SelectionHandler(PCanvas canvas) {
        this.canvas = canvas;
    }

    public void mouseClicked(PInputEvent event) {
        if (!event.isControlDown() && !event.isMetaDown()) {
            this.selector.unselectNodes();
        }
        this.selectNodes(event.getPath().getNodeStackReference());
    }

    public void addNodeSelectionListener(PNodeSelectionListener listener) {
        this.listeners.add(listener);
    }

    public void objectsSelected(Object[] objs) {
        this.selector.unselectNodes();
        PStack stack = new PStack();
        this.canvas.getRoot().getAllNodes((PNodeFilter)new NodeFilter(objs), (Collection)stack);
        this.fireSelected = false;
        this.selectNodes(stack);
        this.fireSelected = true;
    }

    @Override
    public void init() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void start() {
        this.canvas.addInputEventListener((PInputEventListener)this);
    }

    @Override
    public void stop() {
        this.selector.unselectNodes();
        this.canvas.removeInputEventListener((PInputEventListener)this);
    }

    protected void selectNodes(PStack stack) {
        this.selector.selectNodes(stack, true);
        this.firePNodesSelected();
    }

    private void firePNodesSelected() {
        if (this.fireSelected) {
            ArrayList<PNode> nodes = new ArrayList<PNode>(this.selector.getSelectedNodes());
            for (PNodeSelectionListener listener : this.listeners) {
                listener.pNodesSelected(nodes);
            }
        }
    }

    class NodeFilter
    implements PNodeFilter {
        private Object[] objs;

        NodeFilter(Object[] objs) {
            this.objs = objs;
        }

        public boolean accept(PNode pNode) {
            Object obj = pNode.getAttribute((Object)"AGENT");
            if (obj == null) {
                obj = pNode.getAttribute((Object)"Relationship");
            }
            if (obj == null) {
                return false;
            }
            Object[] objectArray = this.objs;
            int n = this.objs.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o.equals(obj)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public boolean acceptChildrenOf(PNode pNode) {
            return true;
        }
    }
}

