/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.piccolo2d.PNode;
import org.piccolo2d.extras.handles.PHandle;
import org.piccolo2d.extras.util.PBoundsLocator;
import org.piccolo2d.extras.util.PLocator;
import org.piccolo2d.extras.util.PNodeLocator;
import org.piccolo2d.util.PStack;
import repast.simphony.visualization.network.PEdge;

public class PNodeSelector {
    private List<PNode> selectedNodes = new ArrayList<PNode>();

    public List<PNode> getSelectedNodes() {
        return this.selectedNodes;
    }

    public void selectNodes(PStack stack, boolean includeEdges) {
        for (PNode node : this.getNodes(stack, includeEdges)) {
            this.selectedNodes.add(node);
            this.addDecoration(node);
        }
    }

    public List<PNode> getNodes(PStack stack, boolean includeEdges) {
        ArrayList<PNode> nodes = new ArrayList<PNode>();
        for (PNode node : stack) {
            if (node.getAttribute((Object)"AGENT") != null || includeEdges && node.getAttribute((Object)"Relationship") != null) {
                nodes.add(node);
                continue;
            }
            if (!includeEdges || !(node.getParent() instanceof PEdge)) continue;
            nodes.add(node.getParent());
        }
        return nodes;
    }

    private void addDecoration(PNode node) {
        if (node instanceof PEdge) {
            node.addChild((PNode)new PHandle((PLocator)new PNodeLocator(node)));
            if (node.getChildrenCount() > 0) {
                node.getChild(0).addChild((PNode)new PHandle((PLocator)new PNodeLocator(node.getChild(0))));
            }
        } else {
            node.addChild((PNode)new PHandle((PLocator)PBoundsLocator.createNorthLocator((PNode)node)));
            node.addChild((PNode)new PHandle((PLocator)PBoundsLocator.createSouthLocator((PNode)node)));
            node.addChild((PNode)new PHandle((PLocator)PBoundsLocator.createEastLocator((PNode)node)));
            node.addChild((PNode)new PHandle((PLocator)PBoundsLocator.createWestLocator((PNode)node)));
        }
    }

    public void unselectNodes() {
        for (PNode node : this.selectedNodes) {
            this.removeHandles(node);
            if (!(node instanceof PEdge) || node.getChildrenCount() <= 0) continue;
            ListIterator iter = node.getChildrenIterator();
            while (iter.hasNext()) {
                this.removeHandles((PNode)iter.next());
            }
        }
        this.selectedNodes.clear();
    }

    private void removeHandles(PNode node) {
        ArrayList<PHandle> handles = new ArrayList<PHandle>();
        ListIterator iter = node.getChildrenIterator();
        while (iter.hasNext()) {
            Object child = iter.next();
            if (!(child instanceof PHandle)) continue;
            handles.add((PHandle)child);
        }
        node.removeChildren(handles);
    }
}

