/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.editor;

import java.awt.geom.Point2D;
import java.util.List;
import org.piccolo2d.PCanvas;
import org.piccolo2d.PNode;
import org.piccolo2d.event.PDragSequenceEventHandler;
import org.piccolo2d.event.PInputEvent;
import org.piccolo2d.event.PInputEventListener;
import org.piccolo2d.nodes.PPath;
import org.piccolo2d.util.PPickPath;
import org.piccolo2d.util.PStack;
import repast.simphony.space.graph.RepastEdge;
import repast.simphony.visualization.editor.DisplayEditor2D;
import repast.simphony.visualization.editor.EditorNotifier;
import repast.simphony.visualization.editor.PEditorEventListener;
import repast.simphony.visualization.editor.PNodeSelector;
import repast.simphony.visualization.visualization2D.Display2D;

public class NetAddEdgeHandler
extends PDragSequenceEventHandler
implements PEditorEventListener {
    private PCanvas canvas;
    private Display2D display;
    private PNodeSelector selector = new PNodeSelector();
    private PPath edge;
    private DisplayEditor2D editor;
    private EditorNotifier notifier;

    public NetAddEdgeHandler(DisplayEditor2D editor, PCanvas canvas, Display2D display, EditorNotifier notifier) {
        this.canvas = canvas;
        this.display = display;
        this.editor = editor;
        this.notifier = notifier;
    }

    @Override
    public void init() {
    }

    @Override
    public void destroy() {
    }

    protected boolean shouldStartDragInteraction(PInputEvent event) {
        if (super.shouldStartDragInteraction(event)) {
            this.selector.unselectNodes();
            this.selectNodes(event.getPath());
            return this.selector.getSelectedNodes().size() == 1;
        }
        return false;
    }

    protected void startDrag(PInputEvent event) {
        super.startDrag(event);
        PNode selectedNode = this.selector.getSelectedNodes().get(0);
        selectedNode.raiseToTop();
        Point2D.Double bound1 = (Point2D.Double)selectedNode.getBounds().getCenter2D();
        this.edge = new PPath.Double();
        this.edge.moveTo((double)((float)bound1.getX()), (double)((float)bound1.getY()));
        this.canvas.getLayer().addChild((PNode)this.edge);
    }

    protected void drag(PInputEvent event) {
        super.drag(event);
        PNode selectedNode = this.selector.getSelectedNodes().get(0);
        Point2D.Double bound1 = (Point2D.Double)selectedNode.getFullBounds().getCenter2D();
        Point2D current = event.getPosition();
        this.edge.reset();
        this.edge.moveTo((double)((float)bound1.getX()), (double)((float)bound1.getY()));
        this.edge.lineTo((double)((float)current.getX()), (double)((float)current.getY()));
    }

    protected void endDrag(PInputEvent event) {
        PNode node;
        super.endDrag(event);
        List<PNode> nodes = this.selector.getNodes(this.canvas.getCamera().pick(event.getCanvasPosition().getX(), event.getCanvasPosition().getY(), 2.0).getNodeStackReference(), false);
        RepastEdge newEdge = null;
        if (nodes.size() > 0) {
            node = nodes.get(0);
            Object source = this.display.findObjForItem(this.selector.getSelectedNodes().get(0));
            Object target = this.display.findObjForItem(node);
            newEdge = this.editor.addEdge(source, target);
            this.notifier.editorEventOccurred();
        }
        this.canvas.getLayer().removeChild((PNode)this.edge);
        this.selector.unselectNodes();
        if (newEdge != null) {
            node = this.display.getVisualItem(newEdge);
            PStack stack = new PStack();
            stack.add((Object)node);
            this.selector.selectNodes(stack, true);
        }
    }

    @Override
    public void start() {
        this.canvas.addInputEventListener((PInputEventListener)this);
    }

    @Override
    public void stop() {
        this.selector.unselectNodes();
        this.canvas.removeInputEventListener((PInputEventListener)this);
    }

    private void selectNodes(PPickPath path) {
        PStack stack = path.getNodeStackReference();
        this.selector.selectNodes(stack, false);
    }
}

