/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.editor;

import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.piccolo2d.PCanvas;
import org.piccolo2d.PNode;
import org.piccolo2d.event.PDragSequenceEventHandler;
import org.piccolo2d.event.PInputEvent;
import org.piccolo2d.event.PInputEventListener;
import org.piccolo2d.util.PPickPath;
import org.piccolo2d.util.PStack;
import repast.simphony.space.graph.Network;
import repast.simphony.space.grid.Grid;
import repast.simphony.space.grid.GridDimensions;
import repast.simphony.space.grid.GridPoint;
import repast.simphony.visualization.editor.DefaultEdgeFinder;
import repast.simphony.visualization.editor.EdgeFinder;
import repast.simphony.visualization.editor.EditorNotifier;
import repast.simphony.visualization.editor.EmptyEdgeFinder;
import repast.simphony.visualization.editor.PEditorEventListener;
import repast.simphony.visualization.editor.PNodeSelector;
import repast.simphony.visualization.grid.Grid2DLayout;
import repast.simphony.visualization.grid.GridShape;
import repast.simphony.visualization.network.PEdge;
import repast.simphony.visualization.visualization2D.Display2D;

public class GridMoveHandler
extends PDragSequenceEventHandler
implements PEditorEventListener {
    private Grid grid;
    private PCanvas canvas;
    private Point2D nodesStartPosition;
    private GridShape shape;
    private Display2D display;
    private boolean shapeAdded = false;
    private PNodeSelector selector = new PNodeSelector();
    private EdgeFinder edgeFinder = new EmptyEdgeFinder();
    private List<PEdge> curEdges = new ArrayList<PEdge>();
    private EditorNotifier notifier;

    public GridMoveHandler(PCanvas canvas, Display2D display, Grid grid, List<Network> nets, EditorNotifier notifier) {
        this.canvas = canvas;
        this.grid = grid;
        this.display = display;
        if (nets.size() > 0) {
            this.edgeFinder = new DefaultEdgeFinder(nets, display);
        }
        this.notifier = notifier;
    }

    @Override
    public void init() {
        this.findGridShape();
    }

    @Override
    public void destroy() {
        if (this.shapeAdded) {
            this.canvas.getLayer().removeChild((PNode)this.shape);
        }
    }

    protected boolean shouldStartDragInteraction(PInputEvent event) {
        if (super.shouldStartDragInteraction(event) && this.shape != null) {
            this.selectNodes(event.getPath());
            return this.selector.getSelectedNodes().size() > 0;
        }
        return false;
    }

    protected void startDrag(PInputEvent event) {
        super.startDrag(event);
        List<PNode> selectedNodes = this.selector.getSelectedNodes();
        selectedNodes.get(0).raiseToTop();
        this.nodesStartPosition = selectedNodes.get(0).getOffset();
        this.curEdges = this.edgeFinder.findEdges(selectedNodes.get(0));
    }

    protected void drag(PInputEvent event) {
        super.drag(event);
        Point2D start = this.canvas.getCamera().localToView((Point2D)this.getMousePressedCanvasPoint().clone());
        Point2D current = event.getPosition();
        Point2D.Double dest = new Point2D.Double();
        ((Point2D)dest).setLocation(this.nodesStartPosition.getX() + (current.getX() - start.getX()), this.nodesStartPosition.getY() + (current.getY() - start.getY()));
        for (PNode node : this.selector.getSelectedNodes()) {
            node.setOffset(((Point2D)dest).getX(), ((Point2D)dest).getY());
        }
        for (PEdge edge : this.curEdges) {
            edge.update();
        }
    }

    protected void endDrag(PInputEvent event) {
        super.endDrag(event);
        Point xy = this.shape.getXY(event.getPosition());
        List<PNode> selectedNodes = this.selector.getSelectedNodes();
        if (xy == null) {
            for (PNode node : selectedNodes) {
                node.setOffset(this.nodesStartPosition.getX(), this.nodesStartPosition.getY());
            }
        } else {
            for (PNode node : selectedNodes) {
                Object obj = this.display.findObjForItem(node);
                GridPoint loc = this.grid.getLocation(obj);
                if ((double)loc.getX() == xy.getX() && (double)loc.getY() == xy.getY()) {
                    node.setOffset(this.nodesStartPosition.getX(), this.nodesStartPosition.getY());
                    continue;
                }
                int[] origin = this.grid.getDimensions().originToIntArray(null);
                int xOffset = origin[0];
                int yOffset = origin[1];
                this.grid.moveTo(obj, new int[]{(int)(xy.getX() - (double)xOffset), (int)(xy.getY() - (double)yOffset)});
            }
            this.notifier.editorEventOccurred();
        }
        this.selector.unselectNodes();
        this.curEdges.clear();
    }

    @Override
    public void start() {
        this.canvas.addInputEventListener((PInputEventListener)this);
    }

    @Override
    public void stop() {
        this.selector.unselectNodes();
        this.canvas.removeInputEventListener((PInputEventListener)this);
    }

    private void selectNodes(PPickPath path) {
        PStack stack = path.getNodeStackReference();
        this.selector.selectNodes(stack, false);
    }

    private void findGridShape() {
        for (Object obj : this.canvas.getRoot().getAllNodes()) {
            PNode node = (PNode)obj;
            if (!(node instanceof GridShape)) continue;
            this.shape = (GridShape)node;
        }
        if (this.shape == null) {
            GridDimensions dims = this.grid.getDimensions();
            Grid2DLayout layout = (Grid2DLayout)this.display.getLayout();
            float unitSize = ((Float)layout.getLayoutProperties().getProperty("cellSize")).floatValue();
            this.shape = new GridShape(unitSize, Color.BLACK, dims.getDimension(0), dims.getDimension(1));
            this.shape.translate(-unitSize / 2.0f, -unitSize / 2.0f);
            this.canvas.getLayer().addChild((PNode)this.shape);
            this.shapeAdded = true;
        }
    }
}

