/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.editor;

import java.util.ArrayList;
import javax.swing.JPanel;
import org.piccolo2d.PCanvas;
import repast.simphony.space.continuous.ContinuousSpace;
import repast.simphony.space.graph.Network;
import repast.simphony.space.grid.Grid;
import repast.simphony.space.projection.Projection;
import repast.simphony.visualization.DisplayEditorLifecycle;
import repast.simphony.visualization.editor.ContSpaceMoveHandler;
import repast.simphony.visualization.editor.DisplayEditor;
import repast.simphony.visualization.editor.DisplayEditor2D;
import repast.simphony.visualization.editor.DisplayEditor3D;
import repast.simphony.visualization.editor.EditorNotifier;
import repast.simphony.visualization.editor.GridAddHandler;
import repast.simphony.visualization.editor.GridAddListener;
import repast.simphony.visualization.editor.GridLocationToolTip;
import repast.simphony.visualization.editor.GridMoveHandler;
import repast.simphony.visualization.editor.NetAddEdgeHandler;
import repast.simphony.visualization.editor.NetAddListener;
import repast.simphony.visualization.editor.NetMoveHandler;
import repast.simphony.visualization.editor.SelectionHandler;
import repast.simphony.visualization.editor.SpaceAddHandler;
import repast.simphony.visualization.editor.SpaceAddListener;
import repast.simphony.visualization.visualization2D.Display2D;
import repast.simphony.visualization.visualization3D.Display3D;

public class EditorFactory {
    private static EditorFactory ourInstance = new EditorFactory();
    private EditorNotifier notifier = new EditorNotifier();

    public static EditorFactory getInstance() {
        return ourInstance;
    }

    private EditorFactory() {
    }

    public void reset() {
        this.notifier.reset();
    }

    public DisplayEditorLifecycle create3DEditor(Display3D display, JPanel panel) {
        this.notifier.addDisplay(display);
        return new DisplayEditor3D(display, panel);
    }

    public DisplayEditorLifecycle create2DEditor(Display2D display, PCanvas canvas, JPanel panel) {
        DisplayEditor2D editor = new DisplayEditor2D(display, panel, this.notifier);
        this.notifier.addDisplay(display);
        GridLocationToolTip ttip = new GridLocationToolTip(canvas.getCamera());
        editor.addModelessListener(ttip);
        SelectionHandler selectionHandler = new SelectionHandler(canvas);
        selectionHandler.addNodeSelectionListener(editor);
        editor.addModalListener(DisplayEditor.Mode.SELECT, selectionHandler);
        Grid grid = null;
        ArrayList<Network> nets = new ArrayList<Network>();
        ContinuousSpace space = null;
        for (Projection proj : display.getInitData().getProjections()) {
            if (proj instanceof Grid) {
                grid = (Grid)proj;
            }
            if (proj instanceof Network) {
                nets.add((Network)proj);
            }
            if (!(proj instanceof ContinuousSpace)) continue;
            space = (ContinuousSpace)proj;
        }
        if (grid != null) {
            editor.addModalListener(DisplayEditor.Mode.MOVE, new GridMoveHandler(canvas, display, grid, nets, this.notifier));
            editor.initAddListener(new GridAddListener(grid, new GridAddHandler(canvas, editor, grid)));
            if (nets.size() > 0) {
                editor.addModalListener(DisplayEditor.Mode.ADD_EDGE, new NetAddEdgeHandler(editor, canvas, display, this.notifier));
            }
        } else if (space != null) {
            ContSpaceMoveHandler moveHandler = new ContSpaceMoveHandler(canvas, display, space, nets, this.notifier);
            editor.initAddListener(new SpaceAddListener(space, new SpaceAddHandler(canvas, display, editor, space)));
            editor.addModalListener(DisplayEditor.Mode.MOVE, moveHandler);
            if (nets.size() > 0) {
                editor.addModalListener(DisplayEditor.Mode.ADD_EDGE, new NetAddEdgeHandler(editor, canvas, display, this.notifier));
            }
        } else if (nets.size() > 0) {
            editor.addModalListener(DisplayEditor.Mode.MOVE, new NetMoveHandler(canvas, display, nets));
            editor.addModalListener(DisplayEditor.Mode.ADD_EDGE, new NetAddEdgeHandler(editor, canvas, display, this.notifier));
            editor.initAddListener(new NetAddListener(canvas, editor, display));
        }
        return editor;
    }
}

