/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.editor;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import repast.simphony.space.continuous.ContinuousSpace;
import repast.simphony.space.graph.Network;
import repast.simphony.space.grid.Grid;
import repast.simphony.space.projection.Projection;
import repast.simphony.visualization.DisplayData;
import repast.simphony.visualization.DisplayEditorLifecycle;
import repast.simphony.visualization.IDisplay;
import repast.simphony.visualization.Layout;
import repast.simphony.visualization.UnitSizeLayoutProperties;
import repast.simphony.visualization.continuous.Continuous2DLayout;
import repast.simphony.visualization.editor.SyntheticDisplayData;
import repast.simphony.visualization.editor.space.Projected3DGrid;
import repast.simphony.visualization.editor.space.Projected3DSpace;
import repast.simphony.visualization.grid.Grid2DLayout;
import repast.simphony.visualization.visualization2D.Display2D;
import repast.simphony.visualization.visualization2D.layout.CircleLayout2D;
import repast.simphony.visualization.visualization2D.style.DefaultEdgeStyle2D;
import repast.simphony.visualization.visualization2D.style.DefaultStyle2D;
import repast.simphony.visualization.visualization3D.Display3D;

public class DisplayEditor3D
implements DisplayEditorLifecycle {
    private static int X = 0;
    private static int Y = 1;
    private static int Z = 2;
    private Display3D display;
    private JPanel panel;
    private JPanel editorPanel;
    private JPanel displayPanel;
    private Grid grid;
    private List<Network> nets = new ArrayList<Network>();
    private ContinuousSpace space;
    private List<DisplayEditorLifecycle> editors = new ArrayList<DisplayEditorLifecycle>();
    private List<IDisplay> displays = new ArrayList<IDisplay>();
    private List<Projected3DGrid> projGrids = new ArrayList<Projected3DGrid>();
    private List<Projected3DSpace> projSpaces = new ArrayList<Projected3DSpace>();
    private static final String XY_TITLE = "X x Y";
    private static final String XZ_TITLE = "X x Z";
    private static final String ZY_TITLE = "Z x Y";
    private JComboBox box;
    private Color[] colors = new Color[]{Color.BLACK, Color.BLUE, Color.CYAN, Color.DARK_GRAY, Color.GREEN, Color.LIGHT_GRAY, Color.MAGENTA, Color.GRAY, Color.ORANGE, Color.PINK, Color.RED};

    public DisplayEditor3D(Display3D display, JPanel panel) {
        this.display = display;
        this.panel = panel;
        this.init();
    }

    private void init() {
        for (Projection proj : this.display.getInitData().getProjections()) {
            if (proj instanceof Grid) {
                this.grid = (Grid)proj;
            }
            if (proj instanceof Network) {
                this.nets.add((Network)proj);
            }
            if (!(proj instanceof ContinuousSpace)) continue;
            this.space = (ContinuousSpace)proj;
        }
    }

    public void run() {
        this.display.setPause(false);
        this.display.update();
        this.display.render();
        this.editorPanel = new JPanel(new BorderLayout());
        JPanel parent = (JPanel)this.panel.getParent();
        parent.remove(this.panel);
        this.displayPanel = new JPanel(new CardLayout());
        this.editorPanel.add((Component)this.displayPanel, "Center");
        JToolBar bar = new JToolBar();
        bar.setLayout(new FlowLayout(2));
        bar.setFloatable(false);
        bar.add(this.createDisplays());
        this.editorPanel.add((Component)bar, "North");
        parent.add(this.editorPanel);
        for (DisplayEditorLifecycle editor : this.editors) {
            editor.run();
        }
        parent.revalidate();
        parent.repaint();
    }

    private void processGrid(DefaultComboBoxModel model) {
        if (this.grid.getDimensions().size() < 3) {
            this.createDisplay(this.createNonNetData((Projection)this.grid), this.createLayout(this.grid), XY_TITLE);
            model.addElement(XY_TITLE);
        } else {
            Projected3DGrid xy = new Projected3DGrid(this.grid, X, Y);
            this.projGrids.add(xy);
            this.createDisplay(this.createNonNetData((Projection)xy), this.createLayout(xy), XY_TITLE);
            model.addElement(XY_TITLE);
            Projected3DGrid xz = new Projected3DGrid(this.grid, X, Z);
            this.projGrids.add(xz);
            this.createDisplay(this.createNonNetData((Projection)xz), this.createLayout(xz), XZ_TITLE);
            model.addElement(XZ_TITLE);
            Projected3DGrid zy = new Projected3DGrid(this.grid, Z, Y);
            this.createDisplay(this.createNonNetData((Projection)zy), this.createLayout(zy), ZY_TITLE);
            model.addElement(ZY_TITLE);
            this.projGrids.add(zy);
        }
    }

    private DisplayData createNonNetData(Projection proj) {
        SyntheticDisplayData data = new SyntheticDisplayData(this.display.getInitData().getContainer());
        data.addProjection(proj);
        for (Network net : this.nets) {
            data.addProjection((Projection)net);
        }
        return data;
    }

    private Layout createLayout(Grid grid) {
        Grid2DLayout layout = new Grid2DLayout(grid);
        UnitSizeLayoutProperties props = new UnitSizeLayoutProperties();
        props.setUnitSize(15.0f);
        layout.setLayoutProperties(props);
        return layout;
    }

    private Layout createLayout(Projected3DSpace space) {
        Continuous2DLayout layout = new Continuous2DLayout(space);
        UnitSizeLayoutProperties props = new UnitSizeLayoutProperties();
        props.setUnitSize(15.0f);
        layout.setLayoutProperties(props);
        return layout;
    }

    private void processSpace(DefaultComboBoxModel model) {
        Projected3DSpace xy = new Projected3DSpace(this.space, X, Y);
        this.projSpaces.add(xy);
        this.createDisplay(this.createNonNetData((Projection)xy), this.createLayout(xy), XY_TITLE);
        model.addElement(XY_TITLE);
        Projected3DSpace xz = new Projected3DSpace(this.space, X, Z);
        this.projSpaces.add(xz);
        this.createDisplay(this.createNonNetData((Projection)xz), this.createLayout(xz), XZ_TITLE);
        model.addElement(XZ_TITLE);
        Projected3DSpace zy = new Projected3DSpace(this.space, Z, Y);
        this.createDisplay(this.createNonNetData((Projection)zy), this.createLayout(zy), ZY_TITLE);
        model.addElement(ZY_TITLE);
        this.projSpaces.add(zy);
    }

    private void processNet(DefaultComboBoxModel model) {
        SyntheticDisplayData data = new SyntheticDisplayData(this.display.getInitData().getContainer());
        for (Network net : this.nets) {
            data.addProjection((Projection)net);
        }
        CircleLayout2D layout = new CircleLayout2D();
        layout.setProjection(this.nets.get(0));
        Display2D display = this.createDisplay(data, layout, "2D Network(s)");
        display.setLayoutFrequency(IDisplay.LayoutFrequency.ON_NEW, 0);
        model.addElement("2D Network(s)");
    }

    private Display2D createDisplay(DisplayData data, Layout layout, String title) {
        Display2D display2D = new Display2D(data, layout);
        this.displays.add(display2D);
        for (Class clazz : this.display.getRegisteredAgents()) {
            display2D.registerStyle(clazz, new DefaultStyle2D());
        }
        int i = 0;
        for (Network net : this.nets) {
            DefaultEdgeStyle2D style = new DefaultEdgeStyle2D();
            Color color = this.getColor(i++);
            style.setPaint(color);
            display2D.registerNetworkStyle(net, style);
        }
        display2D.setLayoutFrequency(IDisplay.LayoutFrequency.AT_UPDATE, 0);
        display2D.init();
        JPanel panel2D = display2D.getPanel();
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)panel2D, "Center");
        this.displayPanel.add((Component)p, title);
        panel2D.setPreferredSize(this.panel.getPreferredSize());
        this.editors.add(display2D.createEditor(panel2D));
        display2D.resetHomeView();
        return display2D;
    }

    private Color getColor(int index) {
        if (index > this.colors.length - 1) {
            index = index % this.colors.length - 1;
        }
        return this.colors[index];
    }

    private JComboBox createDisplays() {
        this.displayPanel.add((Component)this.panel, "3D");
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement("3D");
        if (this.grid != null) {
            this.processGrid(model);
        } else if (this.space != null) {
            this.processSpace(model);
        } else if (this.nets.size() > 0) {
            this.processNet(model);
        }
        this.box = new JComboBox(model);
        this.box.setPrototypeDisplayValue("XXXXXXXXXXXXXXX");
        this.box.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JComboBox src = (JComboBox)evt.getSource();
                String key = src.getSelectedItem().toString();
                ((CardLayout)DisplayEditor3D.this.displayPanel.getLayout()).show(DisplayEditor3D.this.displayPanel, key);
                DisplayEditor3D.this.display.update();
                DisplayEditor3D.this.display.render();
            }
        });
        return this.box;
    }

    public void stop() {
        for (DisplayEditorLifecycle editor : this.editors) {
            editor.stop();
        }
        this.editors.clear();
        for (Projected3DGrid grid : this.projGrids) {
            grid.destroy();
        }
        for (Projected3DSpace space : this.projSpaces) {
            space.destroy();
        }
        for (IDisplay display : this.displays) {
            display.destroy();
        }
        this.displays.clear();
        Container parent = this.editorPanel.getParent();
        parent.remove(this.editorPanel);
        this.displayPanel.removeAll();
        parent.add(this.panel);
        this.panel.revalidate();
        this.panel.repaint();
        parent.invalidate();
        parent.repaint();
    }
}

